% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz.R
\docType{package}
\name{mlr3fda-package}
\alias{mlr3fda}
\alias{mlr3fda-package}
\title{mlr3fda: Extending 'mlr3' to Functional Data Analysis}
\description{
Extends the 'mlr3' ecosystem to functional analysis by adding support for irregular and regular functional data as defined in the 'tf' package. The package provides 'PipeOps' for preprocessing functional columns and for extracting scalar features, thereby allowing standard machine learning algorithms to be applied afterwards. Available operations include simple functional features such as the mean or maximum, smoothing, interpolation, flattening, and functional 'PCA'.
}
\section{Data types}{

To extend mlr3 to functional data, two data types from the tf package are added:
\itemize{
\item \code{tfd_irreg} - Irregular functional data, i.e. the functions are observed for
potentially different inputs for each observation.
\item \code{tfd_reg} - Regular functional data, i.e. the functions are observed for the same input
for each individual.
}

Lang M, Binder M, Richter J, Schratz P, Pfisterer F, Coors S, Au Q, Casalicchio G, Kotthoff L, Bischl B (2019).
\dQuote{mlr3: A modern object-oriented machine learning framework in R.}
\emph{Journal of Open Source Software}.
\doi{10.21105/joss.01903}, \url{https://joss.theoj.org/papers/10.21105/joss.01903}.
}

\seealso{
Useful links:
\itemize{
  \item \url{https://mlr3fda.mlr-org.com}
  \item \url{https://github.com/mlr-org/mlr3fda}
  \item Report bugs at \url{https://github.com/mlr-org/mlr3fda/issues}
}

}
\author{
\strong{Maintainer}: Sebastian Fischer \email{sebf.fischer@gmail.com} (\href{https://orcid.org/0000-0002-9609-3197}{ORCID})

Authors:
\itemize{
  \item Maximilian Mücke \email{muecke.maximilian@gmail.com} (\href{https://orcid.org/0009-0000-9432-9795}{ORCID})
}

Other contributors:
\itemize{
  \item Fabian Scheipl \email{fabian.scheipl@googlemail.com} (\href{https://orcid.org/0000-0001-8172-3603}{ORCID}) [contributor]
  \item Bernd Bischl \email{bernd_bischl@gmx.net} (\href{https://orcid.org/0000-0001-6002-6980}{ORCID}) [contributor]
}

}
