% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OutputTrafoLog.R
\name{OutputTrafoLog}
\alias{OutputTrafoLog}
\title{Output Transformation Log}
\description{
Output transformation that takes the logarithm after min-max scaling to \verb{\\(0, 1\\)}.
}
\examples{
if (requireNamespace("mlr3learners") &
    requireNamespace("DiceKriging") &
    requireNamespace("rgenoud")) {
  library(bbotk)
  library(paradox)
  library(mlr3learners)

  fun = function(xs) {
    list(y = xs$x ^ 2)
  }
  domain = ps(x = p_dbl(lower = -10, upper = 10))
  codomain = ps(y = p_dbl(tags = "minimize"))
  objective = ObjectiveRFun$new(fun = fun, domain = domain, codomain = codomain)

  instance = OptimInstanceBatchSingleCrit$new(
    objective = objective,
    terminator = trm("evals", n_evals = 5))

  xdt = generate_design_random(instance$search_space, n = 4)$data

  instance$eval_batch(xdt)

  learner = default_gp()

  output_trafo = ot("log", invert_posterior = TRUE)

  surrogate = srlrn(learner, output_trafo = output_trafo, archive = instance$archive)

  surrogate$update()

  surrogate$output_trafo$state

  surrogate$predict(data.table(x = c(-1, 0, 1)))

  surrogate$output_trafo$invert_posterior = FALSE

  surrogate$predict(data.table(x = c(-1, 0, 1)))
}
}
\seealso{
Other Output Transformation: 
\code{\link{OutputTrafo}},
\code{\link{OutputTrafoStandardize}},
\code{\link{mlr_output_trafos}}
}
\concept{Output Transformation}
\section{Super class}{
\code{\link[mlr3mbo:OutputTrafo]{mlr3mbo::OutputTrafo}} -> \code{OutputTrafoLog}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{packages}}{(\code{character()})\cr
Set of required packages.
A warning is signaled if at least one of the packages is not installed, but loaded (not attached) later on-demand via \code{\link[=requireNamespace]{requireNamespace()}}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-OutputTrafoLog-new}{\code{OutputTrafoLog$new()}}
\item \href{#method-OutputTrafoLog-update}{\code{OutputTrafoLog$update()}}
\item \href{#method-OutputTrafoLog-transform}{\code{OutputTrafoLog$transform()}}
\item \href{#method-OutputTrafoLog-inverse_transform_posterior}{\code{OutputTrafoLog$inverse_transform_posterior()}}
\item \href{#method-OutputTrafoLog-inverse_transform}{\code{OutputTrafoLog$inverse_transform()}}
\item \href{#method-OutputTrafoLog-clone}{\code{OutputTrafoLog$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3mbo" data-topic="OutputTrafo" data-id="format"><a href='../../mlr3mbo/html/OutputTrafo.html#method-OutputTrafo-format'><code>mlr3mbo::OutputTrafo$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3mbo" data-topic="OutputTrafo" data-id="print"><a href='../../mlr3mbo/html/OutputTrafo.html#method-OutputTrafo-print'><code>mlr3mbo::OutputTrafo$print()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OutputTrafoLog-new"></a>}}
\if{latex}{\out{\hypertarget{method-OutputTrafoLog-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OutputTrafoLog$new(invert_posterior = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{invert_posterior}}{(\code{logical(1)})\cr
Should the posterior predictive distribution be inverted when used within a \link{SurrogateLearner} or \link{SurrogateLearnerCollection}?
Default is \code{FALSE}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OutputTrafoLog-update"></a>}}
\if{latex}{\out{\hypertarget{method-OutputTrafoLog-update}{}}}
\subsection{Method \code{update()}}{
Learn the transformation based on observed data and update parameters in \verb{$state}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OutputTrafoLog$update(ydt)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ydt}}{(\code{\link[data.table:data.table]{data.table::data.table()}})\cr
Data. One row per observation with columns \verb{$cols_y}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OutputTrafoLog-transform"></a>}}
\if{latex}{\out{\hypertarget{method-OutputTrafoLog-transform}{}}}
\subsection{Method \code{transform()}}{
Perform the transformation.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OutputTrafoLog$transform(ydt)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ydt}}{(\code{\link[data.table:data.table]{data.table::data.table()}})\cr
Data. One row per observation with at least columns \verb{$cols_y}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link[data.table:data.table]{data.table::data.table()}} with the transformation applied to the columns \verb{$cols_y}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OutputTrafoLog-inverse_transform_posterior"></a>}}
\if{latex}{\out{\hypertarget{method-OutputTrafoLog-inverse_transform_posterior}{}}}
\subsection{Method \code{inverse_transform_posterior()}}{
Perform the inverse transformation on a posterior predictive distribution characterized by the first and second moment.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OutputTrafoLog$inverse_transform_posterior(pred)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{pred}}{(\code{\link[data.table:data.table]{data.table::data.table()}})\cr
Data. One row per observation characterizing a posterior predictive distribution with the columns \code{mean} and \code{se}.
Can also be a named list of \code{\link[data.table:data.table]{data.table::data.table()}} with posterior predictive distributions for multiple targets corresponding to (\code{cols_y}).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link[data.table:data.table]{data.table::data.table()}} with the inverse transformation applied to the columns \code{mean} and \code{se}.
In the case of the input being a named list of \code{\link[data.table:data.table]{data.table::data.table()}}, the output will be a named list of \code{\link[data.table:data.table]{data.table::data.table()}} with the inverse transformation applied to the columns \code{mean} and \code{se}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OutputTrafoLog-inverse_transform"></a>}}
\if{latex}{\out{\hypertarget{method-OutputTrafoLog-inverse_transform}{}}}
\subsection{Method \code{inverse_transform()}}{
Perform the inverse transformation.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OutputTrafoLog$inverse_transform(ydt)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ydt}}{(\code{\link[data.table:data.table]{data.table::data.table()}})\cr
Data. One row per observation with at least columns \verb{$cols_y}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{\link[data.table:data.table]{data.table::data.table()}} with the inverse transformation applied to the columns \verb{$cols_y}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-OutputTrafoLog-clone"></a>}}
\if{latex}{\out{\hypertarget{method-OutputTrafoLog-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{OutputTrafoLog$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
