% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generic.R, R/neurovec.R
\name{vols}
\alias{vols}
\alias{vols,NeuroVec,numeric-method}
\alias{vols,NeuroVec,missing-method}
\title{Extract an ordered series of 3D volumes.}
\usage{
vols(x, indices, ...)

\S4method{vols}{NeuroVec,numeric}(x, indices)

\S4method{vols}{NeuroVec,missing}(x)
}
\arguments{
\item{x}{the object that supplies the volume data.}

\item{indices}{the subset of volumes to extract.}

\item{...}{additional arguments to be passed to methods.}
}
\value{
A \code{list} containing the extracted 3D volumes from \code{x} in the same order as \code{indices}.
}
\description{
This function extracts an ordered series of 3D volumes from an object that supplies volume data.
The \code{indices} argument specifies the subset of volumes to extract, and can be a vector
of indices or a logical vector. The return value is a list containing the extracted volumes
in the same order as the specified indices.
}
\examples{
vec <- read_vec(system.file("extdata", "global_mask_v4.nii", package="neuroim2"))
vs <- vols(vec)
length(vs) == dim(vec)[4]

vs <- vols(vec, indices=1:3)
length(vs) == 3
}
