% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auc_functions.R
\name{lpo_auc}
\alias{lpo_auc}
\title{Compute the leave-pair-out cross-validation estimator of AUC.}
\usage{
lpo_auc(Y, X, learner = "glm_wrapper", max_pairs = NULL, parallel = FALSE, ...)
}
\arguments{
\item{Y}{A numeric vector of outcomes, assume to equal \code{0} or \code{1}.}

\item{X}{A \code{data.frame} of variables for prediction.}

\item{learner}{A wrapper that implements the desired method for building a 
prediction algorithm. See \code{?glm_wrapper} or read the package vignette
for more information on formatting \code{learner}s.}

\item{max_pairs}{The maximum number of pairs to leave out.}

\item{parallel}{A boolean indicating whether prediction algorithms should be 
trained in parallel. Default to \code{FALSE}.}

\item{...}{Other options (not currently used)}
}
\description{
This estimator is computed by leaving out a pair of one case (\code{Y = 1}) and
one control (\code{Y = 0}). The learner is trained on the remaining observations
and predicted values are obtained for the left-out pair. The estimate is given by
the proportion of left-out pairs for which the case had higher predicted risk
than the control.
}
\examples{
# simulate data
X <- data.frame(x1 = rnorm(50))
Y <- rbinom(50, 1, plogis(X$x1))
# compute lpo_auc for logistic regression
lpo <- lpo_auc(Y = Y, X = X, learner = "glm_wrapper")

}
