% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_author_yml.R
\name{generate_author_yml}
\alias{generate_author_yml}
\title{generate_author_yml}
\usage{
generate_author_yml(
  researchers,
  affiliations,
  corres_name,
  corres_address,
  corres_email
)
}
\arguments{
\item{researchers}{a list of named character vectors. Author information is stored in the name of the vector. Abbreviated affiliations are stored in the vector.}

\item{affiliations}{a list of named character strings. Abbreviated affiliations are stored in the names, the full affiliation is stored in the string.}

\item{corres_name}{A character string. The name of the corresponding author, must match the author details in the researcher argument identically.}

\item{corres_address}{A character string. The address of the corresponding author}

\item{corres_email}{A character string. The email of the corresponding author.}
}
\description{
This function helps organize YAML author and affiliation fields such that authorship order can be changed without having to also update the order of affiliations.
}
\examples{

library(papaja)

generate_author_yml (
 researchers = list(
  "Emma J. Citizen" = c("example_hospital", "example_college"),
  "John H. Smith" = "example_college",
  "Kate C. Jones" = "example_hospital"
   ),
 affiliations = list(
   "example_hospital" = "Southern Example Hospital, NSW, Australia",
   "example_college" = "New Example College, VIC, Australia"
   ),
 corres_name = "Emma J. Citizen",
 corres_address = "123 Example Street, Epping, NSW 2121",
 corres_email = "jane@example.com"
)
}
