% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{visualize_term_interactions}
\alias{visualize_term_interactions}
\title{Visualize Interactions of Genes Involved in the Given Enriched Terms}
\usage{
visualize_term_interactions(result_df, pin_name_path, show_legend = TRUE)
}
\arguments{
\item{result_df}{Data frame of enrichment results. Must-have columns
are: 'Term_Description', 'Up_regulated' and 'Down_regulated'}

\item{pin_name_path}{Name of the chosen PIN or absolute/path/to/PIN.sif. If PIN name,
must be one of c('Biogrid', 'STRING', 'GeneMania', 'IntAct', 'KEGG', 'mmu_STRING'). If
path/to/PIN.sif, the file must comply with the PIN specifications. (Default = 'Biogrid')}

\item{show_legend}{Boolean to indicate whether to display the legend (\code{TRUE})
or not (\code{FALSE}) (default: \code{TRUE})}
}
\value{
list of ggplot objects (named by Term ID) visualizing the interactions of genes involved
in the given enriched terms (annotated in the \code{result_df}) in the PIN used
for enrichment analysis (specified by \code{pin_name_path}).
}
\description{
Visualize Interactions of Genes Involved in the Given Enriched Terms
}
\details{
The following steps are performed for the visualization of interactions
of genes involved for each enriched term: \enumerate{
  \item shortest paths between all affected genes are determined (via \code{\link[igraph]{igraph}})
  \item the nodes of all shortest paths are merged
  \item the PIN is subsetted using the merged nodes (genes)
  \item using the PIN subset, the graph showing the interactions is generated
  \item the final graph is visualized using \code{\link[igraph]{igraph}}, colored by changed
  status (if provided)
}
}
\examples{
\dontrun{
result_df <- example_pathfindR_output[1:2, ]
gg_list <- visualize_term_interactions(result_df, pin_name_path = 'IntAct')
}
}
\seealso{
See \code{\link{visualize_terms}} for the wrapper function
  for creating enriched term diagrams. See \code{\link{run_pathfindR}} for the
  wrapper function of the pathfindR enrichment workflow.
}
