% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uqg.r
\docType{data}
\name{uqg_filters}
\alias{uqg_filters}
\title{Indexing of UQG filters}
\format{
A vector of character strings.
}
\usage{
uqg_filters
}
\description{
Vectors of names of member objects containing spectral data for for UQG
optical glass absorptive and interference (dichroic) filters. Data measured
by P. J. Aphalo with an Agilent 8453 array spectrophotometer. Some of the
filters are Schott glass and we have retained the Schott type names.
}
\note{
Filter supplier: UQG Ltd. The Norman Industrial Estate, Milton,
  Cambridge, England. \url{https://www.uqgoptics.com/}
}
\section{DISCLAIMER}{
 These spectral transmittance data are based on the
  measurement of a single filter of each type. Filters from other production
  batches may differ in their spectral properties, specially for wavelengths
  outside the range described in the manufacturer's published specifications.
  The characteristics of some types of glass filters may change with time
  through surface oxidation or by effect of exposure to radiation including
  solar radiation. The data provided is to be used only as a coarse guide.
  When filter properties are important the filter actually used should be
  measured.
}

\examples{
uqg_filters

}
\seealso{
\code{\link{filters.mspct}}
}
\keyword{datasets}
