% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/color-wrappers.r
\name{spct_SSI}
\alias{spct_SSI}
\title{Spectral (color) similarity index}
\usage{
spct_SSI(
  spct,
  reference.spct = NULL,
  digits = 0,
  isotherms = "mccamy",
  locus = "robertson",
  named = FALSE
)
}
\arguments{
\item{spct, reference.spct}{source_spct Single light source spectra.}

\item{digits}{integer The number of digits after the decimal point in the
returned vector. According to Holm the output should be rounded to the
nearest integer, which corresponds to \code{digits = 0}. To return full
precision, set \code{digits = Inf}.}

\item{isotherms}{character This is only used when reference=NULL. It is
passed to \code{\link[colorSpec]{computeCCT}} in order to compute the CCT
of each test spectrum.}

\item{locus}{character This is only used when reference=NULL. It is
passed to \code{\link[colorSpec]{computeCCT}} in order to compute the CCT
of each test spectrum.}

\item{named}{logical Whether to set the name attribute of the returned
value to the name of the spectrum passed as argument if possible.}
}
\value{
A numeric value between zero and 100.
}
\description{
Wrapper on function \code{\link[colorSpec]{computeSSI}} from package
'colorSpec' that accepts \code{\link[photobiology]{source_spct}} objects.
}
\details{
Please see \code{\link[colorSpec]{computeSSI}} for the details of
  the computations and references.
}
\examples{

spct_SSI(white_led.source_spct, sun.spct)

}
