% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Pfr-Ptot.R
\name{Pfr_Ptot}
\alias{Pfr_Ptot}
\alias{Pfr_Ptot.default}
\alias{Pfr_Ptot.numeric}
\alias{Pfr_Ptot.source_spct}
\title{Calculate phytochrome photoequilibrium}
\usage{
Pfr_Ptot(x, ...)

\method{Pfr_Ptot}{default}(x, ...)

\method{Pfr_Ptot}{numeric}(x, spct.out = length(x) > 20, ...)

\method{Pfr_Ptot}{source_spct}(x, ..., na.rm = FALSE)
}
\arguments{
\item{x}{an R object}

\item{...}{not used}

\item{spct.out}{logical Flag indicating if the returned object should be of
class \code{response_spct} instead of \code{numeric}.}

\item{na.rm}{logical. If \code{TRUE} \code{link[stats]{na.omit}} is
first called on \code{x}.}
}
\value{
If \code{x} is \code{numeric}, giving wavelengths (nm), a vector of
  numeric values giving the \eqn{P_{fr} / P_{tot}} at each wavelength or a
  \code{generic_spct} object with the wavelength values sorted in ascending
  order and the corresponding \eqn{P_{fr} / P_{tot}} values in column
  \code{s.q.response}.

If \code{x} is a \code{source_spct} object, a single numeric value
  giving the \eqn{P_{fr} / P_{tot}}.
}
\description{
Calculate the phytochrome photoequilibrium for monochromatic light from its
wavelength or from a spectrum expressed as spectral irradiance.
}
\details{
The calculations are based on data describing the photochemical
  constants for the plant photoreceptor phytochrome measured \emph{in vitro}
  and available for wavelengths in the range 380 nm to 770 nm as published by
  Mancinelli (1994). For reliable estimates of \eqn{P_{fr} / P_{tot}} from
  spectral irradiance, the spectrum should cover all these wavelengths with
  reasonably high wavelength resolution.
}
\section{Methods (by class)}{
\itemize{
\item \code{Pfr_Ptot(default)}: Default for generic function

\item \code{Pfr_Ptot(numeric)}: Specialization for numeric

\item \code{Pfr_Ptot(source_spct)}: Specialization for source_spct

  Calculate phytochrome photoequilibrium from spectral (photon) irradiance

}}
\note{
If you use these data in a publication, please cite also the original
  source as given under references.
}
\examples{
# monochromatic light
Pfr_Ptot(620) # one wavelength in nm
Pfr_Ptot(c(570, 600, 630, 660, 690, 735, 760)) # six wavelengths
Pfr_Ptot(sun.spct) # spectrum of terrestrial sunligth

}
\references{
Mancinelli, A.L. (1994) The physiology of phytochrome action. In
Photomorphogenesis in plants, 2nd edition. R.E. Kendrick and G.H.M.
Kronenberg, eds. Kluwer Academic Publishers, Dordrecht, pp. 211-269. ISBN
978-0-7923-2551-2 (print), 978-94-011-1884-2 (on-line).
\doi{10.1007/978-94-011-1884-2_10}
}
\seealso{
Other phytochrome-related functions and data: 
\code{\link{PHYs.mspct}},
\code{\link{Pfr_Ptot_R_FR}()},
\code{\link{Phy_Sigma}()},
\code{\link{Phy_Sigma_FR}()},
\code{\link{Phy_Sigma_R}()},
\code{\link{Phy_reaction_rates}()}
}
\concept{phytochrome-related functions and data}
