% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_plumber_file.R
\name{parse_plumber_file}
\alias{parse_plumber_file}
\title{Parse a plumber file}
\usage{
parse_plumber_file(path, env = caller_env())
}
\arguments{
\item{path}{The path to the file to parse}

\item{env}{The environment to evaluate the code and annotations in}
}
\value{
A list containing:
\itemize{
\item \code{route} The main route handling requests according to the parsed file, as a
named list of length one
\item \code{header_route} The route to be attached to header events (fires before the
body has been recieved and can be used to prematurely reject requests based
on their headers), as a named list of length one
\item \code{asset_routes} All the asset routes created by \verb{@static} blocks as a named
list
\item \code{message_handlers} All the websocket message handlers created by \verb{@message}
blocks, as a list
\item \code{api} A list giving the OpenAPI spec as parsed from the file
\item \code{modifier} A single function chaining all the functions from \verb{@plumber}
blocks together
}
}
\description{
This function takes care of parsing an annotated plumber file and creating
one or more routes, API specs, and a modifier function to be called on the
plumber app after the routes have been added. This function does not attach
the parsed data to a plumber api, and it is rarely necessary to call it
directly.
}
\examples{
\dontshow{if (file.exists("path/to/my/plumber/file.R")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Parse a plumber file
parse_plumber_file("path/to/my/plumber/file.R")
\dontshow{\}) # examplesIf}
}
\keyword{internal}
