% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.r
\name{utils_mutate_across}
\alias{utils_mutate_across}
\title{Mutate operation(s) in dataframe column(s)}
\usage{
utils_mutate_across(df, columns, fun, ...)
}
\arguments{
\item{df}{A dataframe.}

\item{columns}{Vector of expression(s) or character string(s) specifying the
columns to apply the function below to in the provided dataframe.}

\item{fun}{Function to execute provided as an expression.}

\item{...}{Argument(s) to be passed to the function above for execution.}
}
\value{
A dataframe.
}
\description{
Applies provided function across specified column(s) in provided dataframe.
}
\examples{
\dontrun{
  df <- data.frame(
    location = "glasgow", occupation = "wine merchant",
    stringsAsFactors = FALSE
  )
  utils_mutate_across(df, c("location", "occupation"), paste0, "!")
}
}
