% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brms-functions.R
\name{predictions_as_draws}
\alias{predictions_as_draws}
\title{brms predictions as draws}
\usage{
predictions_as_draws(
  x,
  predict_fn,
  prediction_names = NULL,
  warn_dims = getOption("priorsense.warn", TRUE),
  ...
)
}
\arguments{
\item{x}{brmsfit object}

\item{predict_fn}{function for predictions}

\item{prediction_names}{optional names of the predictions}

\item{warn_dims}{throw a warning when coercing predict_fn's output from 3
margins to 2 margins?}

\item{...}{further arguments passed to predict_fn}
}
\value{
draws array of predictions
}
\description{
Create predictions using brms functions and convert them into
draws format
}
\examples{
\dontrun{
library(brms)

if ("log_prior_draws.brmsfit" \%in\% methods(log_prior_draws) &&
    ("log_lik_draws.brmsfit" \%in\% methods(log_lik_draws))) {
  fit <- brm(
    yield ~ N * P * K,
    data = npk,
    prior = prior(normal(0, 1), class = "b"),
    refresh = 0
  )

  powerscale_sensitivity(
      fit,
      variable = "_pred",
      prediction = function(x) predictions_as_draws(
                                 x, brms::posterior_epred
                               )
  )
}
}
}
