% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ee_utils.R
\name{ee_utils_sak_validate}
\alias{ee_utils_sak_validate}
\title{Validate a Service account key (SaK)}
\usage{
ee_utils_sak_validate(sakfile, bucket, quiet = FALSE)
}
\arguments{
\item{sakfile}{Character. SaK filename.}

\item{bucket}{Character. Name of the GCS bucket. If bucket is not set,
rgee will tries to create a bucket using \code{googleCloudStorageR::gcs_create_bucket}.}

\item{quiet}{Logical. Suppress info message}
}
\description{
Validate a Service account key (SaK). local_to_gcs, raster_as_ee,
stars_as_ee, and sf_as_ee(via = "gcs_to_asset", ...) need that the SaK
have privileges to write/read objects in a GCS bucket.
}
\examples{
\dontrun{
library(rgee)

ee_Initialize(gcs = TRUE)

# Check a specific SaK
sakfile <- "/home/rgee_dev/sak_file.json"
ee_utils_sak_validate(sakfile, bucket = "rgee_dev")

# Check the SaK for the current user
ee_utils_sak_validate()
}
}
