% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03_SANBA_estimate_partitions.R
\name{estimate_partition}
\alias{estimate_partition}
\alias{estimate_partition.SANvi}
\alias{estimate_partition.SANmcmc}
\alias{summary.partition_mcmc}
\alias{summary.partition_vi}
\alias{print.partition_mcmc}
\alias{print.partition_vi}
\alias{plot.partition_mcmc}
\alias{plot.partition_vi}
\title{Estimate the Observational and Distributional Partition}
\usage{
estimate_partition(object, ...)

\method{estimate_partition}{SANvi}(object, ordered = TRUE, ...)

\method{estimate_partition}{SANmcmc}(object, ordered = TRUE, add_burnin = 0, ncores = 0, ...)

\method{summary}{partition_mcmc}(object, ...)

\method{summary}{partition_vi}(object, ...)

\method{print}{partition_mcmc}(x, ...)

\method{print}{partition_vi}(x, ...)

\method{plot}{partition_mcmc}(
  x,
  DC_num = NULL,
  type = c("ecdf", "boxplot", "scatter"),
  alt_palette = FALSE,
  ...
)

\method{plot}{partition_vi}(
  x,
  DC_num = NULL,
  type = c("ecdf", "boxplot", "scatter"),
  alt_palette = FALSE,
  ...
)
}
\arguments{
\item{object}{Object of class \code{SANmcmc} (usually, the result of a call to \code{\link{fit_fiSAN}},
\code{\link{fit_fSAN}}, or \code{\link{fit_CAM}} with \code{est_method = "MCMC"}) or \code{SANvi}
(the result of a call to \code{\link{fit_fiSAN}}, \code{\link{fit_fSAN}}, or \code{\link{fit_CAM}} with \code{est_method = "VI"}).}

\item{...}{Additional graphical parameters to be passed to the \code{plot} function.}

\item{ordered}{Logical, if \code{TRUE} (default), the function sorts the distributional cluster labels reflecting the
increasing values of medians of the data assigned to each DC. If \code{FALSE}, no ordering is applied.}

\item{add_burnin}{Integer (default = 0). Number of observations to discard as additional burn-in (only for \code{SANmcmc} objects).}

\item{ncores}{A parameter to pass to the \code{salso::salso()} function (only for \code{SANmcmc} objects). The number of CPU cores to use for parallel computing; a value of zero indicates the use of all cores on the system.}

\item{x}{The result of a call to \code{\link{estimate_partition}}.}

\item{DC_num}{An integer or a vector of integers indicating which distributional clusters to plot.}

\item{type}{What type of plot should be drawn. Available types are \code{"boxplot"}, \code{"ecdf"}, and \code{"scatter"}.}

\item{alt_palette}{Logical, the color palette to be used. Default is \code{R} base colors (\code{alt_palette = FALSE}).}
}
\value{
A list of class \code{partition_vi} or \code{partition_mcmc} containing
\itemize{
  \item \code{obs_level}: a data frame containing the data values, their group indexes, and the observational and distributional clustering assignments for each observation.
  \item \code{dis_level}: a vector with the distributional clustering assignment for each unit.
}
}
\description{
Given the output of a \code{sanba} model-fitting function, this method estimates both the observational and distributional partitions.
For MCMC objects, it computes a point estimate using \code{\link[salso:salso]{salso::salso()}};
for Variational Inference (VI) objects, the cluster allocation is determined by the label with the highest estimated variational probability.
}
\examples{
set.seed(123)
y <- c(rnorm(40,0,0.3), rnorm(20,5,0.3))
g <- c(rep(1:6, each = 10))
out <- fit_fSAN(y = y, group = g, "VI", vi_param = list(n_runs = 10))
plot(out)
clust <- estimate_partition(out)
summary(clust)
plot(clust, lwd = 2, alt_palette = TRUE)
plot(clust, type = "scatter", alt_palette = FALSE, cex = 2)

set.seed(123)
y <- c(rnorm(40,0,0.3), rnorm(20,5,0.3))
g <- c(rep(1:6, each = 10))
out <- fit_fSAN(y = y, group = g, "MCMC", mcmc_param=list(nrep=500,burn=200))
plot(out)
clust <- estimate_partition(out)
summary(clust)
plot(clust, lwd = 2)
plot(clust,  type = "boxplot", alt_palette = TRUE)
plot(clust,  type = "scatter", alt_palette = TRUE, cex = 2, pch = 4)

}
\seealso{
\code{\link[salso:salso]{salso::salso()}}
}
