% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/thinning.R
\name{thinning}
\alias{thinning}
\title{Applies thinning to pairs of coordinates}
\usage{
thinning(xy, minimum.distance = NULL)
}
\arguments{
\item{xy}{A data frame with columns named "x" and "y" representing geographic coordinates.}

\item{minimum.distance}{Numeric, minimum distance to be set between nearby points, in the same units as the coordinates of xy.}
}
\value{
A data frame with the same columns as \code{xy} with points separated by the defined minimum distance.
}
\description{
Resamples a set of points with x and y coordinates to impose a minimum distance among nearby points.
}
\details{
Generally used to remove redundant points that could produce pseudo-replication, and to limit sampling bias by disaggregating clusters of points.
}
\examples{
if(interactive()){

 #load example data
 data(plant_richness_df)

 #thinning to points separated by 5 degrees
 plant_richness.thin <- thinning(
   x = plant_richness_df,
   minimum.distance = 5 #points separated by at least 5 degrees
   )

 plant_richness.thin

}
}
\seealso{
\code{\link[=thinning_til_n]{thinning_til_n()}}
}
