% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sprinter.R
\name{sprinter}
\alias{sprinter}
\title{Sparse Reluctant Interaction Modeling}
\usage{
sprinter(x, y, num_keep = NULL, square = FALSE, lambda = NULL,
  nlam = 100, lam_min_ratio = ifelse(nrow(x) < ncol(x), 0.01, 1e-04))
}
\arguments{
\item{x}{An \code{n} by \code{p} design matrix of main effects. Each row is an observation of \code{p} main effects.}

\item{y}{A response vector of size \code{n}.}

\item{num_keep}{Number of candidate interactions to keep in Step 2. If \code{num_keep} is not specified (as default), it will be set to \code{[n / log n]}.}

\item{square}{Indicator of whether squared effects should be fitted in Step 1. Default to be FALSE.}

\item{lambda}{A user specified list of tuning parameter. Default to be NULL, and the program will compute its own \code{lambda} path based on \code{nlam} and \code{lam_min_ratio}.}

\item{nlam}{The number of \code{lambda} values. Default value is \code{100}.}

\item{lam_min_ratio}{The ratio of the smallest and the largest values in \code{lambda}. The largest value in \code{lambda} is usually the smallest value for which all coefficients are set to zero. Default to be \code{1e-2} in the \code{n} < \code{p} setting.}
}
\value{
An object of S3 class "\code{sprinter}".
 \describe{
  \item{\code{n}}{The sample size.}
  \item{\code{p}}{The number of main effects.}
  \item{\code{a0}}{Estimate of intercept.}
  \item{\code{coef}}{Estimate of regression coefficients.}
  \item{\code{idx}}{Indices of all main effects and interactions in Step 3.}
  \item{\code{fitted}}{Fitted response value. It is a \code{n}-by-\code{nlam} matrix, with each column representing a fitted response vector for a value of lambda.}
  \item{\code{lambda}}{The sequence of \code{lambda} values used.}
  \item{\code{call}}{Function call.}
 }
}
\description{
This is the main function that fits interaction models with a path of tuning parameters (for Step 3).
}
\examples{
set.seed(123)
n <- 100
p <- 200
x <- matrix(rnorm(n * p), n, p)
y <- x[, 1] - 2 * x[, 2] + 3 * x[, 1] * x[, 3] - 4 * x[, 4] * x[, 5] + rnorm(n)
mod <- sprinter(x = x, y = y)

}
\seealso{
\code{\link{cv.sprinter}}
}
