% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/config.R
\name{createForestModelConfig}
\alias{createForestModelConfig}
\title{Create a forest model config object}
\usage{
createForestModelConfig(
  feature_types = NULL,
  num_trees = NULL,
  num_features = NULL,
  num_observations = NULL,
  variable_weights = NULL,
  leaf_dimension = 1,
  alpha = 0.95,
  beta = 2,
  min_samples_leaf = 5,
  max_depth = -1,
  leaf_model_type = 1,
  leaf_model_scale = NULL,
  variance_forest_shape = 1,
  variance_forest_scale = 1,
  cutpoint_grid_size = 100
)
}
\arguments{
\item{feature_types}{Vector of integer-coded feature types (integers where 0 = numeric, 1 = ordered categorical, 2 = unordered categorical)}

\item{num_trees}{Number of trees in the forest being sampled}

\item{num_features}{Number of features in training dataset}

\item{num_observations}{Number of observations in training dataset}

\item{variable_weights}{Vector specifying sampling probability for all p covariates in ForestDataset}

\item{leaf_dimension}{Dimension of the leaf model (default: \code{1})}

\item{alpha}{Root node split probability in tree prior (default: \code{0.95})}

\item{beta}{Depth prior penalty in tree prior (default: \code{2.0})}

\item{min_samples_leaf}{Minimum number of samples in a tree leaf (default: \code{5})}

\item{max_depth}{Maximum depth of any tree in the ensemble in the model. Setting to \code{-1} does not enforce any depth limits on trees. Default: \code{-1}.}

\item{leaf_model_type}{Integer specifying the leaf model type (0 = constant leaf, 1 = univariate leaf regression, 2 = multivariate leaf regression). Default: \code{0}.}

\item{leaf_model_scale}{Scale parameter used in Gaussian leaf models (can either be a scalar or a q x q matrix, where q is the dimensionality of the basis and is only >1 when \code{leaf_model_int = 2}). Calibrated internally as \code{1/num_trees}, propagated along diagonal if needed for multivariate leaf models.}

\item{variance_forest_shape}{Shape parameter for IG leaf models (applicable when \code{leaf_model_type = 3}). Default: \code{1}.}

\item{variance_forest_scale}{Scale parameter for IG leaf models (applicable when \code{leaf_model_type = 3}). Default: \code{1}.}

\item{cutpoint_grid_size}{Number of unique cutpoints to consider (default: \code{100})}
}
\value{
ForestModelConfig object
}
\description{
Create a forest model config object
}
\examples{
config <- createForestModelConfig(num_trees = 10, num_features = 5, num_observations = 100)
}
