% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{sur_sample_gibbs_cpp}
\alias{sur_sample_gibbs_cpp}
\title{Power Prior Gibbs sampling}
\usage{
sur_sample_gibbs_cpp(
  Sigma,
  M,
  X,
  X0,
  XtX,
  X0tX0,
  Y,
  Y0,
  y,
  y0,
  a0,
  pvec,
  burnin,
  thin
)
}
\arguments{
\item{Sigma}{initial value for covariance matrix}

\item{M}{number of samples}

\item{X}{design matrix for current data}

\item{X0}{design matrix for historical data}

\item{XtX}{matrix that is \code{crossprod(cbind(X1, ..., XJ))}}

\item{X0tX0}{matrix that is \code{crossprod(cbind(X01, ..., X0J))}}

\item{Y}{future response as matrix (Y1, ..., YJ)}

\item{Y0}{historical response as matrix (Y01, ..., Y0J)}

\item{y}{future response as vector}

\item{y0}{historical response as vector}

\item{a0}{power prior parameter}

\item{pvec}{\code{vector} giving number of covariates per endpoint}

\item{burnin}{Burn-in parameter}

\item{thin}{Thin parameter}
}
\value{
sampled covariance matrix
}
\description{
This is a c++ implementation of Gibbs sampling SUR model with power prior
}
