% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parents.R
\name{parents}
\alias{parents}
\alias{parents,taxlist,character-method}
\title{Retrieve parents for specific concepts}
\usage{
parents(taxlist, level, ...)

\S4method{parents}{taxlist,character}(taxlist, level, concept, ...)
}
\arguments{
\item{taxlist}{An object of class \linkS4class{taxlist} containing a taxonomic
list.}

\item{level}{A character value indicating the level at which the parents will
be extracted (upwards in the taxonomic ranks).}

\item{...}{Further arguments passed among methods.}

\item{concept}{A vector containing concept IDs. The taxa for which the
parents will be retrieved. If not provided, parents for every single
taxon concept in 'taxlist' will be retrieved.}
}
\description{
Retrieve IDs of parents for selected taxa in a taxonomic list.
}
\examples{
# Random selection of 5 taxa
IDs <- sample(Easplist@taxonRelations$TaxonConceptID, 5)

# Print names and names of parents
print_name(Easplist, IDs)
print_name(Easplist, parents(Easplist, "genus", IDs))
print_name(Easplist, parents(Easplist, "family", IDs))
}
