% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tib_spec.R
\name{tspec_df}
\alias{tspec_df}
\alias{tspec_object}
\alias{tspec_recursive}
\alias{tspec_row}
\title{Create a Tibblify Specification}
\usage{
tspec_df(
  ...,
  .input_form = c("rowmajor", "colmajor"),
  .names_to = NULL,
  vector_allows_empty_list = FALSE
)

tspec_object(
  ...,
  .input_form = c("rowmajor", "colmajor"),
  vector_allows_empty_list = FALSE
)

tspec_recursive(
  ...,
  .children,
  .children_to = .children,
  .input_form = c("rowmajor", "colmajor"),
  vector_allows_empty_list = FALSE
)

tspec_row(
  ...,
  .input_form = c("rowmajor", "colmajor"),
  vector_allows_empty_list = FALSE
)
}
\arguments{
\item{...}{Column specification created by \verb{tib_*()} or \verb{tspec_*()}.}

\item{.input_form}{The input form of data frame like lists. Can be one of:
\itemize{
\item \code{"rowmajor"}: The default. The data frame is formed by a list of rows.
\item \code{"colmajor"}: The data frame is a named list of columns.
}}

\item{.names_to}{A string giving the name of the column which will contain
the names of elements of the object list. If \code{NULL}, the default, no name
column is created}

\item{vector_allows_empty_list}{Should empty lists for \code{input_form = "vector"}
be accepted and treated as empty vector?}

\item{.children}{A string giving the name of field that contains the children.}

\item{.children_to}{A string giving the column name to store the children.}
}
\value{
A tibblify specification.
}
\description{
Use \code{tspec_df()} to specify how to convert a list of objects to a tibble.
Use \code{tspec_row()} resp. \code{tspec_object()} to specify how to convert an object
to a one row tibble resp. a list.
}
\details{
In column major format all fields are required, regardless of the \code{required}
argument.
}
\examples{
tspec_df(
  id = tib_int("id"),
  name = tib_chr("name"),
  aliases = tib_chr_vec("aliases")
)

# To create multiple columns of the same type use the bang-bang-bang (!!!)
# operator together with `purrr::map()`
tspec_df(
  !!!purrr::map(purrr::set_names(c("id", "age")), tib_int),
  !!!purrr::map(purrr::set_names(c("name", "title")), tib_chr)
)

# The `tspec_*()` functions can also be nested
spec1 <- tspec_object(
  int = tib_int("int"),
  chr = tib_chr("chr")
)
spec2 <- tspec_object(
  int2 = tib_int("int2"),
  chr2 = tib_chr("chr2")
)

tspec_df(spec1, spec2)
}
