% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coercion.R
\name{as.tind}
\alias{as.tind}
\alias{as.tind.numeric}
\alias{as.tind.character}
\alias{as.tind.Date}
\alias{as.tind.POSIXct}
\alias{as.tind.POSIXlt}
\alias{as.tind.data.frame}
\alias{as.tind.tind}
\alias{as.year}
\alias{as.quarter}
\alias{as.month}
\alias{as.week}
\alias{as.date}
\alias{as.date_time}
\alias{as.time}
\title{Conversion to \code{tind} Class}
\usage{
as.tind(x, ...)

\method{as.tind}{numeric}(x, type = NULL, tz = NULL, ...)

\method{as.tind}{character}(
  x,
  type = NULL,
  format = NULL,
  order = NULL,
  locale = NULL,
  tz = NULL,
  ...
)

\method{as.tind}{Date}(x, ...)

\method{as.tind}{POSIXct}(x, tz = NULL, digits = 0L, ...)

\method{as.tind}{POSIXlt}(x, tz = NULL, digits = 0L, ...)

\method{as.tind}{data.frame}(x, ...)

\method{as.tind}{tind}(x, type = NULL, tz = NULL, ...)

as.year(x, ...)

as.quarter(x, ...)

as.month(x, ...)

as.week(x, ...)

as.date(x, ...)

as.date_time(x, tz = NULL, ...)

as.time(x, ...)
}
\arguments{
\item{x}{an R object (e.g., a numeric vector, a character vector, a \code{Date}
or \code{POSIXct} object).}

\item{...}{further arguments passed to or from other methods.}

\item{type}{a character determining time index type or \code{NULL}.}

\item{tz}{(optional) a character value determining the time zone (the default
\code{NULL} is interpreted as the system time zone).
See \code{\link{tzone}} documentation for information on time zones.}

\item{format}{a character determining input format(s) as in \code{\link{strptind}}.
(or \code{NULL}).}

\item{order}{a character determining order(s) of time index components
in the input as in \code{\link{parse_t}} (or \code{NULL}).}

\item{locale}{(optional) a character value determining locale or \code{NULL}
(the default, interpreted as the current system locale),
see \link{calendar-names} for information on locale settings.}

\item{digits}{an integer value (0--6) determining the number of decimal places
for seconds to be preserved during conversion (0 by default).}
}
\value{
An object of \code{tind} class of length equal to the length of the argument.
For data frame version the length of the result is equal to the number of rows
in the data frame.
}
\description{
\code{as.tind} method allows for conversion of numeric and character vectors
as well as objects of \code{Date}, \code{POSIXct}, and \code{POSIXlt}
classes to \code{tind} objects to \code{tind}.

\code{as.tind} method for \code{tind} class allows to change the type
of index of an object of \code{tind} class.
Convenience functions \code{as.year}, \code{as.quarter}, \code{as.month},
\code{as.week}, \code{as.date}, \code{as.date_time}, \code{as.time} allow
to quickly convert argument to the indicated type.
}
\details{
\strong{Numeric vectors}

The following numeric representations are automatically recognised
(between year 1800 and 2199): \code{YYYY} (years), \code{YYYYQ} (quarters),
\code{YYYYMM} (months), and \code{YYYYMMDD} (dates). Conversion from
numeric vectors to other index types requires type specification via \code{type}
argument.

Date-time indices are represented as number of seconds since the Epoch
(1970-01-01 00:00 UTC). Time of day is represented as the number of seconds
since midnight.

\strong{Character vectors}

\code{as.tind} automatically recognises many different formats. If automatic
recognition fails, \code{type} argument could help identify the format.
For less standard formats / representations, one can use either \code{format}
argument (which is forwarded to \code{\link{strptind}}) or \code{order}
argument (which is forwarded to \code{\link{parse_t}}).

\strong{Data frames}

If a data frame has one column, it is converted using appropriate method
depending on the column type. In case there are two or more columns, they are
pasted and the resulting character vector is parsed. As this may not be
computationally efficient, other ways of constructing \code{tind} should be
considered, for example, use of \code{\link{tind}} constructor.

\strong{\code{Date} and \code{POSIXt} classes}

Conversion of \code{Date} objects returns time index of type \code{"d"} (date).
\code{POSIXct} and \code{POSIXlt} classes are converted to index of type \code{"t"}
(date-time). If time zone attribute is not set for the argument, system time zone
is assumed.

\strong{Other classes representing time indices}

For conversions between \code{tind} class and other classes (from packages
other than \pkg{base}), see \code{\link{tind-other}}.
}
\examples{
## numeric and character arguments
# years
as.tind(1999)
as.tind("1999")
# quarters
as.tind(20043)
as.tind("20043")
# months
as.tind(200109)
as.tind("2001-09")
as.tind("200109")
# need proper locale to recognise English month names
as.tind("Sep 2001", locale = "C")
# weeks (ISO 8601)
# numeric YYYYWW representation is not automatically recognised, need type
as.tind(200936, "w")
as.tind("2009-W36")
# dates
as.tind(20200726)
as.tind("2020-07-26")
# need proper locale to recognise English month names
as.tind("Jul 26, 2020", locale = "C")
as.tind("07/26/20")
# date-time
as.tind("2000-08-16 08:17:38")
# time
as.tind("08:17:38")
as.tind(08 * 3600 + 17 * 60 + 38, type = "h")

## conversion from Date and POSIXct
as.tind(Sys.Date())
as.tind(Sys.time())

## as.year, ..., as.time
# today
(x <- today())
as.year(x)
as.quarter(x)
as.month(x)
as.week(x)
# midnight
as.date_time(x)
# current time
(x <- now())
as.year(x)
as.quarter(x)
as.month(x)
as.week(x)
as.date(x)
as.time(x)

}
\seealso{
\code{\link{tind}} constructor,
\code{\link{strptind}} function for \code{format} specifications,
\code{\link{parse_t}} function for \code{order} specifications,
\link{tind-coercion} for conversions from \code{tind},
and \code{\link{tind-other}} for conversions between \code{tind} class and
other classes (from packages other than \pkg{base}).
}
