% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tinterval.R, R/print_summ_str.R
\name{tinterval}
\alias{tinterval}
\alias{\%--\%}
\alias{is.tinterval}
\alias{as.tinterval}
\alias{as.tinterval.character}
\alias{as.tinterval.tinterval}
\alias{as.tinterval.list}
\alias{as.tinterval.data.frame}
\alias{as.character.tinterval}
\alias{format.tinterval}
\alias{as.list.tinterval}
\alias{as.data.frame.tinterval}
\alias{[.tinterval}
\alias{[[.tinterval}
\alias{[<-.tinterval}
\alias{[[<-.tinterval}
\alias{c.tinterval}
\alias{print.tinterval}
\alias{summary.tinterval}
\title{Time Intervals}
\usage{
tinterval(start = NULL, end = NULL, ...)

start \%--\% end

is.tinterval(x)

as.tinterval(x, ...)

\method{as.tinterval}{character}(x, sep, ...)

\method{as.tinterval}{tinterval}(x, type = NULL, tz = NULL, ...)

\method{as.tinterval}{list}(x, ...)

\method{as.tinterval}{data.frame}(x, ...)

\method{as.character}{tinterval}(x, ...)

\method{format}{tinterval}(x, sep = " -- ", open = "...", aux = TRUE, empty = "-", ...)

\method{as.list}{tinterval}(x, ...)

\method{as.data.frame}{tinterval}(x, ...)

\method{[}{tinterval}(x, i)

\method{[[}{tinterval}(x, i)

\method{[}{tinterval}(x, i) <- value

\method{[[}{tinterval}(x, i) <- value

\method{c}{tinterval}(...)

\method{print}{tinterval}(x, ...)

\method{summary}{tinterval}(object, ...)
}
\arguments{
\item{start}{an object of \code{tind} class or an R object coercible to it,
beginning of the interval(s).}

\item{end}{an object of \code{tind} class or an R object coercible to it,
end of the interval(s).}

\item{...}{objects of \code{tinterval} class to be concatenated by \code{c}
or additional arguments passed to or from methods.}

\item{x}{an object of \code{tinterval} class or an R object passed
to \code{as.tinterval}.}

\item{sep}{a character string used as separator between start and end
of an interval (\code{" -- "} by default).}

\item{type}{a character determining time index type or \code{NULL}.}

\item{tz}{(optional) a character value determining the time zone (the default
\code{NULL} is interpreted as the system time zone).
See \code{\link{tzone}} documentation for information on time zones.}

\item{open}{a character string used to print open interval ends
(\code{"..."} by default).}

\item{aux}{a logical value, if \code{TRUE} (the default), auxiliary
information (time spans of intervals) is added to the output.}

\item{empty}{a character string used to mark empty intervals (\code{"-"} by default).}

\item{i}{an integer vector of indices or a logical vector indicating selection.}

\item{value}{replacement value, should be coercible to \code{tinterval}.}

\item{object}{an object of \code{tinterval} class.}
}
\value{
\code{tinterval}, \code{\%--\%}, and \code{as.tinterval} return
objects of \code{tinterval} class.

\code{is.tinterval} returns a logical value.

In general, methods for \code{tinterval} return objects of \code{tinterval} class.

\code{as.character} and \code{format} return character vectors.

\code{as.list} and \code{as.data.frame} return a two-element list and
a two-column data frame, respectively. Names are set to \code{c("start", "end")}.

\code{print} returns its argument invisibly and is used for its side effect.

\code{summary} returns an object of class \code{c("summaryDefault", "table")}.
}
\description{
Objects of auxiliary \code{tinterval} class represent time intervals as pairs
of time indices (start and end). Time intervals can be constructed via a call
to \code{tinterval} function or using convenience \code{\%--\%} operator.
Open-ended intervals are supported.
The main applications of this class are set operations (see \link{set-ops})
and checking if a particular time index belongs to (one of) given interval(s)
(see \code{\link{match_t}}).
}
\details{
\code{tinterval} constructor takes two arguments: beginnings and ends of intervals.
Additional arguments (passed via \code{...}) are forwarded to \code{as.tind}
method. \code{x \%--\% y} is equivalent to \code{tinterval(x, y)}.

\code{as.tinterval} can be used to construct time intervals from character
strings, two-element lists, or two-column data frames. Additionally,
\code{as.tinterval} allows to convert time intervals represented using
one type of time indices to time intervals represented by time indices
of higher resolution (for example months to dates).

Internally, time intervals are represented by lists of two vectors. However,
in operations they behave like vectors with standard indexing and replacement
operators implemented.

Interval limits can be accessed via \code{$} operator: \code{x$start}
returns vector of beginnings of intervals in \code{x} and \code{x$end}
vector of ends.

For discrete time indices (represented as integers, i.e. years, quarters,
months, weeks, dates, arbitrary integer indices) time interval \code{a \%--\% b}
represents all indices falling in \code{a} or after and in \code{b} or before, i.e.
the set: \eqn{\{x: a \le x \wedge x \le b\} = \{a, a + 1, \dots, b - 1, b\}}.
For continuous time indices (representing point in time, i.e. date-time, time of day,
arbitrary numeric indices) time interval \code{a \%--\% b} represents
all indices starting with \code{a} and \emph{before} \code{b}, i.e. the set:
\eqn{[a, b)}.
The difference in interpretations between discrete and continuous time indices
assures consistency during conversions.
Consider time interval \code{"2025-08-02" \%--\% "2025-08-03"}. This represents
all date-time indices falling on one of those two days, so exactly \code{2025-08-02 00:00}
or after but before \code{2025-08-04 00:00}.
}
\examples{
td <- today()
# from today till the day after tomorrow
td \%--\% (td + 2)
# from today till the end of next year
td \%--\% (as.year(td) + 1)
# from the beginning of the year till today
as.year(td) \%--\% td
# 9 to 5
as.time("9am") \%--\% as.time("5pm")
# 7 to 9 and 4 to 6 via constructor...
tinterval(as.time(c("7am", "4pm")), as.time(c("9am", "6pm")))
# ... or more naturally via concatenation
c(as.time("7am") \%--\% as.time("9am"), as.time("4pm") \%--\% as.time("6pm"))
# automatic parsing
as.tinterval(c("2023-01 -- 2024-06", "2024-12 -- 2025-03"))
# empty time interval
as.tinterval(c("2024-01 -- 2023-06"))
# open time interval
"2024-01" \%--\% NULL
"2024-01" \%--\% as.month(NA)
as.tinterval(c("2024-01 -- ..."))
# +/- operators
(x <- tinterval(td, td + 2))
x + c(0, 7, 14)
x \%+w\% 0:2
# indexing
(x <- "2023-01" \%--\% "2024-06")
(x <- x \%+y\% c(0, 2, 4))
x[2:3]
x[-1]
# beginnings and ends of intervals
x$start
x$end
# conversion from interval represented by months to dates
(x <- "2025-07" \%--\% "2025-08")
as.tinterval(x, "d")
# conversion from interval represented by dates to date-time (see Details)
(x <- "2025-08-02" \%--\% "2025-08-03")
as.tinterval(x, "t")

}
\seealso{
\link{set-ops} for the description of set operations on time intervals,
\code{\link{match_t}} for matching time indices to time intervals.
}
