% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsforecast_1.2.0.R
\name{tslineplot}
\alias{tslineplot}
\title{Time Series Line Plots}
\usage{
tslineplot(
  x,
  t = NULL,
  pred = NULL,
  pred.t = NULL,
  cil = NULL,
  ciu = NULL,
  ci.t = NULL,
  trend = c("none", "linear", "smooth"),
  title = NULL,
  x.name = NULL,
  pred.name = "Predicted",
  x.lwidth = 0.7,
  pred.lwidth = 0.7,
  x.col = "darkgrey",
  pred.col = "steelblue4",
  ci.col = "royalblue",
  t.name = "Date/Time",
  t.text.angle = 90,
  t.numbreak = 10,
  ylim = NULL
)
}
\arguments{
\item{x}{a univariate time series object or a numeric vector or matrix.}

\item{t}{a vector or list of time periods in which the series values were observed. The length of \code{t} must be identical to the length of \code{x}.}

\item{pred}{a vector of predicted or forecasted values of a univariate time series. This parameter can be omitted. Default is \code{NULL}.}

\item{pred.t}{a vector of time periods in which the predicted or forecasted values of a univariate time series are estimated. This parameter can be omitted. Default is \code{NULL}.}

\item{cil}{a vector of the prediction intervals' lower limits. Only necessary if \code{pred} and \code{pred.t} are provided. This parameter can be omitted. Default is \code{NULL}.}

\item{ciu}{a vector of the prediction intervals' upper limits. Only necessary if \code{pred} and \code{pred.t} are provided. This parameter can be omitted. Default is \code{NULL}.}

\item{ci.t}{a vector of the time periods in which the prediction intervals are estimated.This parameter can be omitted. Default is \code{NULL}.}

\item{trend}{indicate whether a trend line should be included in the time series plot. Available options are `\code{none}`, `\code{linear}`, and `\code{smooth}`. If `\code{linear}`, a straight trend line estimated by linear regression model will be included. If `\code{smooth}`, the trend line will be estimated by LOESS regression model. Default is \code{NULL}, indicating that no trend line should be displayed.}

\item{title}{title of the time series line plot.}

\item{x.name}{name of the series. If omitted here, the series name found by \code{tsname()} will be taken over here. If \code{tsname()} is \code{NULL}, the variable name will be used instead. Default is \code{NULL}.}

\item{pred.name}{name of the series' predicted/forecasted values. Only necessary if \code{pred} and \code{pred.t} are provided. Default is `\code{Predicted}`.}

\item{x.lwidth}{line width of the series line plot. Default is \code{0.7}.}

\item{pred.lwidth}{line width of the line plot for the predicted/forecasted values. Default is \code{0.7}.}

\item{x.col}{line colour of the time series line plot. Default is `\code{darkgrey}`.}

\item{pred.col}{line colour of the line plot for the predicted/forecasted values. Default is `\code{steelblue4}`.}

\item{ci.col}{area colour of the prediction intervals. Default is `\code{royalblue}`.}

\item{t.name}{name of the x-axis (time axis). Default is `\code{Date/Time}`.}

\item{t.text.angle}{angle of the tick labels on the x-axis (time axis). Default is \code{90} (vertical).}

\item{t.numbreak}{number of tick labels on the x-axis (time axis). Default is \code{10}.}

\item{ylim}{value limit of the y-axis. The values should be specified in \code{c(lower_limit, upper_limit)}, where \code{lower_limit} and \code{upper_limit} are the values of the smallest and largest number of the y-axis, respectively. Default is \code{NULL}.}
}
\value{
A line plot of \code{x} will be displayed with no further values or objects returned.
}
\description{
Produce line plot of a given univariate time series.
}
\details{
If \code{x} is a \code{ts} object, parameter \code{t} can be omitted. You can convert a vector, a matrix or data frame column using \code{tsconvert} to a \code{ts} object.
}
\examples{
tslineplot(airport$Travellers, trend = "linear")
}
\author{
Ka Yui Karl Wu
}
