% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random_search.R
\name{random_search}
\alias{random_search}
\title{Randomize the output of the Genetic Algorithm}
\usage{
random_search(result, Polygon1, n = 20, best = 1, Plot = FALSE, max_dist = 2.2)
}
\arguments{
\item{result}{The resulting matrix of the function \code{\link{genetic_algorithm}}}

\item{Polygon1}{The considered area as SpatialPolygon, SimpleFeature Polygon
or coordinates as matrix/data.frame}

\item{n}{The number of random searches to be performed. Default is 20.}

\item{best}{Which best individuals should be the starting conditions for a
random search. The default is 1.}

\item{Plot}{Should the random search be plotted? Default is \code{FALSE}}

\item{max_dist}{A numeric value multiplied by the rotor radius to perform
collision checks. Default is \code{2.2}}
}
\value{
Returns a list.
}
\description{
Perform a random search in the grid cells, to further optimize
the output of the wind farm layout.
}
\examples{
\donttest{
new <- random_search(resultrect, sp_polygon, n = 20, best = 4)
plot_random_search(resultRS = new, result = resultrect, Polygon1 = sp_polygon, best = 2)
}
}
\seealso{
Other Randomization: 
\code{\link{plot_random_search}()},
\code{\link{random_search_single}()}
}
\concept{Randomization}
