% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scores_su_sui_tlfb.R
\name{check_args_tlfb}
\alias{check_args_tlfb}
\title{Check arguments for TLFB summary score functions}
\usage{
check_args_tlfb(
  data,
  name,
  substance = NULL,
  period = NULL,
  days = NULL,
  wknd = NULL,
  co_use = NULL,
  binge = NULL,
  position = NULL
)
}
\arguments{
\item{data}{tibble. A data frame containing the TLFB raw data.}

\item{name}{character. The name of the output column for the computed score.}

\item{substance}{character (vector). The substance(s) to compute the score
for. Must be one or several of the following values:
\itemize{
\item \code{"'Fake' Marijuana or Synthetics"}
\item \code{"Alcohol"}
\item \code{"Anabolic Steroids"}
\item \code{"Any Other Drug They Used to Get High"}
\item \code{"Blunts or Combined Tobacco and Marijuana in Joints"}
\item \code{"CBD (Non-Medical Use)"}
\item \code{"Cathinones such as Bath Salts, Drone, or Meph"}
\item \code{"Cigars, Little Cigars, or Cigarillos"}
\item \code{"Cocaine or Crack Cocaine"}
\item \code{"Concentrated Marijuana Tinctures"}
\item \code{"Ecstasy, Molly, or MDMA"}
\item \code{"Electronic Nicotine or Vaping Products"}
\item \code{"GHB, Liquid G, or Georgia Homeboy"}
\item \code{"Hallucinogen Drugs including LSD, PCP, Peyote, Mescaline, DMT, AMT, or Foxy"}
\item \code{"Heroin, Opium, Junk, Smack, or Dope"}
\item \code{"Hookah with Tobacco"}
\item \code{"Inhalants"}
\item \code{"Ketamine or Special K"}
\item \code{"Marijuana Edibles"}
\item \code{"Marijuana Infused Alcohol Drinks"}
\item \code{"Methamphetamine, Meth, or Crystal Meth"}
\item \code{"Nicotine Replacements"}
\item \code{"OTC Cough or Cold Medicine, DXM, 'Lean', or 'Purple Drank'"}
\item \code{"Prescription Anxiolytics, Tranquilizers, or Sedatives"}
\item \code{"Prescription Pain Relievers or Opioids"}
\item \code{"Prescription Stimulants"}
\item \code{"Psilocybin, Magic Mushrooms, or Shrooms"}
\item \code{"Salvia"}
\item \code{"Smokeless Tobacco, Chew, or Snus"}
\item \code{"Smoking Marijuana Flower"}
\item \code{"Smoking Marijuana Oils or Concentrates"}
\item \code{"Tobacco Cigarette"}
\item \code{"Tobacco in a Pipe"}
\item \code{"Vaped Marijuana Flower"}
\item \code{"Vaped Marijuana Oils or Concentrates"}
\item \code{"Marijuana (all forms)"}
\item \code{"Nicotine (all forms)"}
}

(Default: \code{NULL}, i.e., all substances are considered.)}

\item{period}{character (vector). The period for which the score is
computed for. Must be one of \code{"detailed"} (last year before date of TLFB
interview) or \code{"estimated"} (more than one year before date of TLFB).
(Default: \code{NULL}, i.e., all periods are considered). Cannot be used in
combination with \code{days}.}

\item{days}{integer. Number of days before the TLFB interview to consider.
(Default: \code{NULL}, i.e., all days are considered). Cannot be used in
combination with \code{period}.}

\item{wknd}{logical. Whether the score should be computed for weekends only
(\code{TRUE}) or for week days only (\code{FALSE}). (Default: \code{NULL}, i.e., all days
are considered).}

\item{co_use}{character (vector). Co-use substance(s). Must be one or several
of the possible values for \code{substance} listed above. Only days where the
specified substance(s) was/were used together with (one of) the co-use
substance(s) are considered. (Default: \code{NULL}, i.e., co-use is not
considered). \code{co_use} cannot be specified without \code{substance} and
can only contain substance(s) that are not specified in \code{substance}.}

\item{binge}{(named list of) numeric. Binge threshold(s) for the
substance(s). If only one value is provided, it is used, independent of the
sex of the participant. If a list is provided, it must contain two named
elements: \code{"F"} (female) and \code{"M"} (male) with the respective sex-specific
binge thresholds. Only days where the the quantity of the substance(s)
exceeds the specified threshold(s) are considered. (Default: \code{NULL}, i.e.,
binge behavior is not considered).}

\item{position}{character. The position of the substance use event. Must be
one of \code{"first"} or \code{"last"}. (Default: \code{NULL}, i.e., position is not
considered).}
}
\value{
\code{NULL}. Invisibly returns \code{NULL} if all checks pass. Otherwise, an
error is raised.
}
\description{
Validates the arguments to compute a TLFB substance use score.
}
\keyword{internal}
