% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pullGeno.R
\name{pullQtlHaplo}
\alias{pullQtlHaplo}
\title{Pull QTL haplotypes}
\usage{
pullQtlHaplo(
  pop,
  trait = 1,
  haplo = "all",
  chr = NULL,
  asRaw = FALSE,
  simParam = NULL
)
}
\arguments{
\item{pop}{an object of \code{\link{Pop-class}}}

\item{trait}{an integer. Indicates which trait's
QTL haplotypes to retrieve.}

\item{haplo}{either "all" for all haplotypes or an integer
for a single set of haplotypes. Use a value of 1 for female
haplotypes and a value of 2 for male haplotypes in diploids.}

\item{chr}{a vector of chromosomes to retrieve. If NULL,
all chromosome are retrieved.}

\item{asRaw}{return in raw (byte) format}

\item{simParam}{an object of \code{\link{SimParam}}}
}
\value{
Returns a matrix of QTL haplotypes.
}
\description{
Retrieves QTL haplotype data
}
\examples{
#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=15)

#Set simulation parameters
SP = SimParam$new(founderPop)
\dontshow{SP$nThreads = 1L}
SP$addTraitA(10)
SP$addSnpChip(5)

#Create population
pop = newPop(founderPop, simParam=SP)
pullQtlHaplo(pop, simParam=SP)

}
