% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AM_prior.R
\name{AM_prior_K_Pois}
\alias{AM_prior_K_Pois}
\title{Computes the prior number of clusters}
\usage{
AM_prior_K_Pois(n, gamma, Lambda)
}
\arguments{
\item{n}{The sample size.}

\item{gamma}{The \code{gamma} parameter of the Dirichlet distribution.}

\item{Lambda}{The \code{Lambda} parameter of the Poisson.}
}
\value{
an \code{\link{AM_prior}} object, that is a vector of length n, reporting the values of the prior on the number of clusters induced by the prior on \code{M} and \code{w}, i.e. \code{p^*_k} for \code{k=1,...,n}. See \insertCite{argiento2019infinity}{AntMAN} for more details.
}
\description{
This function computes the prior on the number of clusters, i.e. occupied components of the mixture for a Finite Dirichlet process when the prior on the component-weights of the mixture is a
Dirichlet with parameter \code{gamma} (i.e. when unnormalized weights are distributed as Gamma(\eqn{\gamma},1)). This function can be used when the prior on the number of
components is Shifted Poisson of parameter \code{Lambda}. See \insertCite{argiento2019infinity}{AntMAN} for more details.
}
\details{
There are no default values.
}
\examples{
n <- 82
Lambda <- 10
gam_po <- 0.1550195
prior_K_po <-  AM_prior_K_Pois(n,gam_po,Lambda)
plot(prior_K_po)
}
\keyword{clusters}
\keyword{number}
\keyword{of}
\keyword{prior}
