% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do_shots_stats.R
\name{do_shots_stats}
\alias{do_shots_stats}
\title{Shots statistics}
\usage{
do_shots_stats(data_filter, data_shots_zones)
}
\arguments{
\item{data_filter}{Shooting filtered data obtained with \code{\link{do_filter_data}}.}

\item{data_shots_zones}{Shooting data with the court zones.}
}
\value{
A list with the following three elements:
\itemize{
\item all_shots: Shooting data frame associated with the filters given to the function.
\item summary_shots: Summary of the shots as a whole.
\item summary_shots_zone: Summary of the shots by zone.
}
}
\description{
Compute both the total and by zone two-point and threes statistics.
}
\examples{
\dontrun{
df0 <- do_divide_court_zones(acb_shooting_data_2425)

df1 <- do_filter_data(df0, "2024-2025", "", "", "", "", "")

shots_stats <- do_shots_stats(df1, df0) 

all_shots <- shots_stats$all_shots

summary_shots <- shots_stats$summary_shots

summary_shots_zone <- shots_stats$summary_shots_zone
}

}
\seealso{
\code{\link{do_divide_court_zones}}, \code{\link{do_filter_data}}
}
\author{
Guillermo Vinue
}
