% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_mcmc.R
\name{BayesFBHborrow.NoBorrow}
\alias{BayesFBHborrow.NoBorrow}
\title{Run the MCMC sampler without Bayesian Borrowing}
\usage{
\method{BayesFBHborrow}{NoBorrow}(
  data,
  data_hist = NULL,
  borrow = FALSE,
  model_choice = "no_borrow",
  tuning_parameters = NULL,
  hyperparameters = NULL,
  lambda_hyperparameters = list(a_lambda = 0.01, b_lambda = 0.01),
  iter = 2000,
  warmup_iter = 2000,
  refresh = 0,
  verbose = FALSE,
  max_grid = 2000
)
}
\arguments{
\item{data}{data.frame containing atleast three vectors of "tte" (time-to-event)
and "event" (event indicator), and covariates "X_i" (where i should be a number/
indicator of the covariate)}

\item{data_hist}{NULL (not used)}

\item{borrow}{FALSE (default), will run the model with borrowing}

\item{model_choice}{'no_borrow' (default), for no borrowing}

\item{tuning_parameters}{list of "cprop_beta", "Jmax", and "pi_b". Default is 
("Jmax" = 5, "cprop_beta" = 0.5, "pi_b" = 0.5)}

\item{hyperparameters}{list containing the hyperparameters c("a_sigma", "b_sigma", 
"phi", clam_smooth"). Default is list("a_sigma" = 2, "b_sigma" = 2, "phi" = 3 ,
"clam_smooth" = 0.8)}

\item{lambda_hyperparameters}{contains two hyperparameters ("a_lambda" and "b_lambda")
used for the update of lambda, default is c(0.01, 0.01)}

\item{iter}{number of iterations for MCMC sampler. Default is 2000}

\item{warmup_iter}{number of warmup iterations (burn-in) for MCMC sampler. 
Default is 2000}

\item{refresh}{number of iterations between printed console updates. Default
is 0}

\item{verbose}{FALSE (default), choice of output, if TRUE will output 
intermittent results into console}

\item{max_grid}{grid size for the smoothed baseline hazard. Default is 2000}
}
\value{
a nested list of two items, 'out' and 'plots'. The list 'out' will
contain all the samples of the MCMC chain, as well as acceptance ratios. The
latter, 'plots', contains plots (and data) of the smoothed baseline hazard, 
smoothed survival, a histogram of the sampled number of split points, and the
trace plot of the treatment effect beta_1
}
\description{
Main function of the BayesFBHborrow package. This generic function 
calls the correct MCMC sampler for time-to-event without Bayesian borrowing.
}
\examples{
set.seed(123)
# Load the example data
data(piecewise_exp_cc, package = "BayesFBHborrow")

# Set your tuning parameters
tuning_parameters <- list("Jmax" = 5,
                          "cprop_beta" = 3.25)
                          
# Set initial values to default
out <- BayesFBHborrow(piecewise_exp_cc, NULL, borrow = FALSE, 
                      tuning_parameters = tuning_parameters,
                      iter = 2, warmup_iter = 0)
}
