/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.substmodel;

import dr.evolution.datatype.DataType;
import dr.evomodel.substmodel.EigenDecomposition;
import dr.evomodel.substmodel.FrequencyModel;
import dr.evomodel.substmodel.SubstitutionModel;
import dr.inference.markovjumps.MarkovJumpsCore;
import dr.inference.markovjumps.MarkovJumpsType;
import dr.inference.markovjumps.StateHistory;
import dr.inference.model.AbstractModel;
import dr.inference.model.Model;
import dr.inference.model.Variable;

public class MarkovJumpsSubstitutionModel
extends AbstractModel {
    public int stateCount;
    private double[] rateReg;
    private double[] ievcRateRegEvec;
    private double[] tmp1;
    private double[] transitionProbs;
    private double[] rateMatrix;
    protected double[] reward;
    protected double[] registration;
    protected SubstitutionModel substModel;
    private EigenDecomposition eigenDecomposition;
    private MarkovJumpsCore markovJumpsCore;
    private boolean regRateChanged = true;
    protected MarkovJumpsType type;
    protected DataType dataType;
    private static final boolean PRECOMPUTE = true;

    public MarkovJumpsSubstitutionModel(SubstitutionModel substitutionModel) {
        this(substitutionModel, MarkovJumpsType.COUNTS);
    }

    public MarkovJumpsSubstitutionModel(SubstitutionModel substitutionModel, MarkovJumpsType markovJumpsType) {
        super(substitutionModel.getModelName());
        this.substModel = substitutionModel;
        this.eigenDecomposition = substitutionModel.getEigenDecomposition();
        this.stateCount = substitutionModel.getDataType().getStateCount();
        this.markovJumpsCore = new MarkovJumpsCore(this.stateCount);
        this.type = markovJumpsType;
        this.setupStorage();
        this.addModel(substitutionModel);
        this.dataType = substitutionModel.getDataType();
    }

    protected void setupStorage() {
        this.rateMatrix = new double[this.stateCount * this.stateCount];
        this.transitionProbs = new double[this.stateCount * this.stateCount];
        this.rateReg = new double[this.stateCount * this.stateCount];
        this.ievcRateRegEvec = new double[this.stateCount * this.stateCount];
        this.tmp1 = new double[this.stateCount * this.stateCount];
        this.registration = new double[this.stateCount * this.stateCount];
        this.reward = new double[this.stateCount];
    }

    public MarkovJumpsType getType() {
        return this.type;
    }

    public void setRegistration(double[] dArray) {
        if (this.type == MarkovJumpsType.COUNTS || this.type == MarkovJumpsType.HISTORY) {
            System.arraycopy(dArray, 0, this.registration, 0, this.stateCount * this.stateCount);
            for (int i = 0; i < this.stateCount; ++i) {
                this.registration[i * this.stateCount + i] = 0.0;
            }
        } else if (this.type == MarkovJumpsType.REWARDS) {
            int n = 0;
            for (int i = 0; i < this.stateCount; ++i) {
                this.reward[i] = dArray[i];
                for (int j = 0; j < this.stateCount; ++j) {
                    this.registration[n] = i == j ? dArray[i] : 0.0;
                    ++n;
                }
            }
        } else {
            throw new RuntimeException("Unknown expectation type in MarkovJumps");
        }
        this.regRateChanged = true;
    }

    public double[] getRegistration() {
        return this.registration;
    }

    private void makeRateRegistrationMatrix(double[] dArray, double[] dArray2, double[] dArray3) {
        if (this.type == MarkovJumpsType.COUNTS || this.type == MarkovJumpsType.HISTORY) {
            this.substModel.getInfinitesimalMatrix(this.rateMatrix);
            int n = 0;
            for (int i = 0; i < this.stateCount; ++i) {
                for (int j = 0; j < this.stateCount; ++j) {
                    dArray2[n] = this.rateMatrix[n] * dArray[n];
                    ++n;
                }
            }
        } else if (this.type == MarkovJumpsType.REWARDS) {
            System.arraycopy(dArray, 0, dArray2, 0, this.stateCount * this.stateCount);
        } else {
            throw new RuntimeException("Unknown expectation type in MarkovJumps");
        }
        MarkovJumpsCore.matrixMultiply(dArray2, this.eigenDecomposition.getEigenVectors(), this.stateCount, this.tmp1);
        MarkovJumpsCore.matrixMultiply(this.eigenDecomposition.getInverseEigenVectors(), this.tmp1, this.stateCount, dArray3);
        this.regRateChanged = false;
    }

    public double getMarginalRate() {
        if (this.regRateChanged) {
            this.makeRateRegistrationMatrix(this.registration, this.rateReg, this.ievcRateRegEvec);
        }
        FrequencyModel frequencyModel = this.substModel.getFrequencyModel();
        double d = 0.0;
        int n = 0;
        for (int i = 0; i < this.stateCount; ++i) {
            double d2 = frequencyModel.getFrequency(i);
            for (int j = 0; j < this.stateCount; ++j) {
                d += d2 * this.rateReg[n++];
            }
        }
        return d;
    }

    public void computeCondStatMarkovJumps(double d, double[] dArray) {
        this.substModel.getTransitionProbabilities(d, this.transitionProbs);
        this.computeCondStatMarkovJumps(d, this.transitionProbs, dArray);
    }

    public double getProcessForSimulant(StateHistory stateHistory) {
        double d = this.type == MarkovJumpsType.COUNTS || this.type == MarkovJumpsType.HISTORY ? stateHistory.getTotalRegisteredCounts(this.registration) : stateHistory.getTotalReward(this.reward);
        return d;
    }

    public void computeCondStatMarkovJumps(double d, double[] dArray, double[] dArray2) {
        if (this.regRateChanged) {
            this.makeRateRegistrationMatrix(this.registration, this.rateReg, this.ievcRateRegEvec);
        }
        double[] dArray3 = this.eigenDecomposition.getEigenVectors();
        double[] dArray4 = this.eigenDecomposition.getInverseEigenVectors();
        double[] dArray5 = this.eigenDecomposition.getEigenValues();
        this.markovJumpsCore.computeCondStatMarkovJumpsPrecompute(dArray3, dArray4, dArray5, this.ievcRateRegEvec, d, dArray, dArray2);
    }

    public void computeJointStatMarkovJumps(double d, double[] dArray) {
        if (this.regRateChanged) {
            this.makeRateRegistrationMatrix(this.registration, this.rateReg, this.ievcRateRegEvec);
        }
        double[] dArray2 = this.eigenDecomposition.getEigenVectors();
        double[] dArray3 = this.eigenDecomposition.getInverseEigenVectors();
        double[] dArray4 = this.eigenDecomposition.getEigenValues();
        this.markovJumpsCore.computeJointStatMarkovJumpsPrecompute(dArray2, dArray3, dArray4, this.ievcRateRegEvec, d, dArray);
    }

    public SubstitutionModel getSubstitutionModel() {
        return this.substModel;
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        if (model == this.substModel) {
            this.regRateChanged = true;
        }
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
    }

    @Override
    protected void acceptState() {
    }
}

