/*
 * Decompiled with CFR 0.152.
 */
package dr.geo;

import dr.geo.KMLRenderer;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class KMLViewer
extends JComponent {
    KMLRenderer renderer;
    BufferedImage image;

    public KMLViewer(String string) {
        this.renderer = new KMLRenderer(string, Color.green, Color.blue);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        if (this.image == null || this.image.getWidth() != this.getWidth() || this.image.getHeight() != this.getHeight()) {
            this.image = new BufferedImage(this.getWidth(), this.getHeight(), 2);
            this.renderer.render(this.image);
        }
        graphics.drawImage(this.image, 0, 0, null);
        this.drawGrid(5, 5, (Graphics2D)graphics, this.renderer.viewTransform.getTransform());
    }

    private void drawGrid(int n, int n2, Graphics2D graphics2D, AffineTransform affineTransform) {
        Line2D.Double double_;
        double d;
        for (d = -180.0; d < 180.0; d += (double)n2) {
            double_ = new Line2D.Double(d, -90.0, d, 90.0);
            graphics2D.draw(affineTransform.createTransformedShape(double_));
        }
        for (d = -90.0; d < 90.0; d += (double)n) {
            double_ = new Line2D.Double(-180.0, d, 180.0, d);
            graphics2D.draw(affineTransform.createTransformedShape(double_));
        }
    }

    public static void main(String[] stringArray) {
        int n;
        int n2;
        String string = stringArray[0];
        JFrame jFrame = new JFrame("KMLViewer - " + string);
        KMLViewer kMLViewer = new KMLViewer(string);
        Rectangle2D rectangle2D = kMLViewer.renderer.getBounds();
        jFrame.getContentPane().add("Center", kMLViewer);
        if (rectangle2D.getHeight() > rectangle2D.getWidth()) {
            n2 = 900;
            n = (int)((double)n2 * rectangle2D.getWidth() / rectangle2D.getHeight());
        } else {
            n = 900;
            n2 = (int)((double)n * rectangle2D.getHeight() / rectangle2D.getWidth());
        }
        System.out.println("Height = " + n2 + ", Width = " + n);
        jFrame.setSize(n, n2);
        jFrame.setVisible(true);
    }
}

