/*
 * Decompiled with CFR 0.152.
 */
package dr.geo.color;

import dr.geo.color.ColorScheme;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

public interface ChannelColorScheme {
    public static final ChannelColorScheme CHANNEL_RED = new MultipleChannelColorScheme(new ColorScheme[]{ColorScheme.WHITE_RED});
    public static final ChannelColorScheme CHANNEL_RED_BLUE = new MultipleChannelColorScheme(new ColorScheme[]{ColorScheme.WHITE_RED, ColorScheme.WHITE_BLUE});

    public Color getColor(List<Double> var1, List<Double> var2, List<Double> var3);

    public static class MultipleChannelColorScheme
    implements ChannelColorScheme {
        private final ColorScheme[] schemes;

        MultipleChannelColorScheme(ColorScheme[] colorSchemeArray) {
            this.schemes = colorSchemeArray;
        }

        @Override
        public Color getColor(List<Double> list, List<Double> list2, List<Double> list3) {
            ArrayList<Color> arrayList = new ArrayList<Color>();
            int n = this.schemes.length;
            for (int i = 0; i < n; ++i) {
                arrayList.add(this.schemes[i].getColor(list.get(i), list2.get(i), list3.get(i)));
            }
            return MultipleChannelColorScheme.blend(arrayList);
        }

        private static Color blend(List<Color> list) {
            double d = 0.0;
            for (Color color : list) {
                d += (double)color.getAlpha();
            }
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            double d5 = 0.0;
            for (Color color : list) {
                double d6 = color.getAlpha();
                d2 += d6 * (double)color.getRed();
                d3 += d6 * (double)color.getGreen();
                d4 += d6 * (double)color.getBlue();
                d5 = Math.max(d5, d6);
            }
            return new Color((int)(d2 /= d), (int)(d3 /= d), (int)(d4 /= d), (int)d5);
        }
    }
}

