/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.trace;

import dr.inference.trace.DensityEstimate;
import dr.math.distributions.GammaKDEDistribution;
import dr.math.distributions.KernelDensityEstimatorDistribution;
import dr.math.distributions.NormalKDEDistribution;
import dr.stats.Variate;
import dr.util.FrequencyDistribution;

public class KernelDensityEstimate
extends DensityEstimate {
    private KernelDensityEstimatorDistribution kde;
    private double lowerBoundary = 0.0;
    private double upperBoundary = Double.POSITIVE_INFINITY;
    private static final double minDensity = 1.0E-5;

    public KernelDensityEstimate(Double[] doubleArray, int n) {
        this(KernelDensityEstimatorDistribution.Type.GAUSSIAN, doubleArray, n);
    }

    public KernelDensityEstimate(KernelDensityEstimatorDistribution.Type type, Double[] doubleArray, int n) {
        super(doubleArray, n);
        switch (type) {
            case GAUSSIAN: {
                this.kde = new NormalKDEDistribution(doubleArray);
            }
            case GAMMA: {
                this.kde = new GammaKDEDistribution(doubleArray);
            }
        }
        throw new RuntimeException("Unknown type");
    }

    public KernelDensityEstimate(String string, Double[] doubleArray, int n) {
        super(doubleArray, n);
        this.kde = new NormalKDEDistribution(doubleArray);
    }

    public KernelDensityEstimatorDistribution getKernelDensityEstimatorDistribution() {
        return this.kde;
    }

    protected void calculateDensity(Variate variate, int n) {
        FrequencyDistribution frequencyDistribution = this.calculateFrequencies(variate, n);
        this.xCoordinates = new Variate.D();
        this.yCoordinates = new Variate.D();
        double d = frequencyDistribution.getLowerBound() - frequencyDistribution.getBinSize() / 2.0;
        int n2 = 0;
        while (this.kde.pdf(d) > 1.0E-5 && d > this.lowerBoundary) {
            d -= frequencyDistribution.getBinSize();
            ++n2;
        }
        this.xCoordinates.add(d);
        this.yCoordinates.add(0.0);
        d += frequencyDistribution.getBinSize();
        for (int i = 0; i < frequencyDistribution.getBinCount() + n2; ++i) {
            this.xCoordinates.add(d);
            this.yCoordinates.add(this.kde.pdf(d));
            d += frequencyDistribution.getBinSize();
        }
        while (this.kde.pdf(d) > 1.0E-5) {
            this.xCoordinates.add(d);
            this.yCoordinates.add(this.kde.pdf(d));
            d += frequencyDistribution.getBinSize();
        }
        this.xCoordinates.add(d);
        this.yCoordinates.add(0.0);
    }

    public static void main(String[] stringArray) {
        Double[] doubleArray = new Double[101];
        for (int i = 0; i <= 100; ++i) {
            doubleArray[i] = (double)i / 100.0;
            System.out.println(doubleArray[i]);
        }
        KernelDensityEstimate kernelDensityEstimate = new KernelDensityEstimate("Gaussian", doubleArray, 512);
        Variate.D d = new Variate.D(doubleArray);
        KernelDensityEstimatorDistribution kernelDensityEstimatorDistribution = kernelDensityEstimate.getKernelDensityEstimatorDistribution();
        System.out.println("Bandwidth: " + kernelDensityEstimatorDistribution.getBandWidth());
        System.out.println();
    }
}

