/*
 * Decompiled with CFR 0.152.
 */
package dr.oldevomodel.sitemodel;

import dr.inference.model.AbstractModel;
import dr.inference.model.Bounds;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.oldevomodel.sitemodel.SiteModel;
import dr.oldevomodel.substmodel.FrequencyModel;
import dr.oldevomodel.substmodel.SubstitutionModel;
import dr.oldevomodel.substmodel.YangCodonModel;
import java.util.Vector;

public class SampleStateModel
extends AbstractModel
implements SiteModel {
    public static final double OMEGA_MAX_VALUE = 100.0;
    public static final double OMEGA_MIN_VALUE = 0.0;
    private final Vector substitutionModels;
    private final Parameter proportionParameter;
    private final int categoryCount;

    public SampleStateModel(Parameter parameter, Parameter parameter2, Vector vector) {
        super("sampleStateModel");
        int n;
        this.substitutionModels = vector;
        for (n = 0; n < vector.size(); ++n) {
            this.addModel((SubstitutionModel)vector.elementAt(n));
        }
        this.categoryCount = vector.size();
        this.addVariable(parameter);
        parameter.addBounds(new Parameter.DefaultBounds(1000.0, 0.0, 1));
        this.proportionParameter = parameter2;
        this.addVariable(parameter2);
        parameter2.addBounds(new Parameter.DefaultBounds(1.0, 0.0, parameter2.getDimension()));
        parameter2.setParameterValue(0, 0.5);
        for (n = 1; n < this.categoryCount; ++n) {
            parameter2.setParameterValue(n, 0.5 / (double)(this.categoryCount - 1));
        }
        if (this.categoryCount > 1) {
            for (n = 0; n < this.categoryCount; ++n) {
                Parameter parameter3 = (Parameter)((YangCodonModel)vector.elementAt(n)).getVariable(0);
                Parameter parameter4 = null;
                Parameter parameter5 = null;
                if (n == 0) {
                    parameter5 = (Parameter)((YangCodonModel)vector.elementAt(n + 1)).getVariable(0);
                    parameter3.addBounds(new omegaBounds(parameter4, parameter5));
                    continue;
                }
                if (n == this.categoryCount - 1) {
                    parameter4 = (Parameter)((YangCodonModel)vector.elementAt(n - 1)).getVariable(0);
                    parameter3.addBounds(new omegaBounds(parameter4, parameter5));
                    continue;
                }
                parameter5 = (Parameter)((YangCodonModel)vector.elementAt(n + 1)).getVariable(0);
                parameter4 = (Parameter)((YangCodonModel)vector.elementAt(n - 1)).getVariable(0);
                parameter3.addBounds(new omegaBounds(parameter4, parameter5));
            }
        }
    }

    @Override
    public SubstitutionModel getSubstitutionModel() {
        return null;
    }

    @Override
    public boolean integrateAcrossCategories() {
        return true;
    }

    @Override
    public int getCategoryCount() {
        return this.categoryCount;
    }

    @Override
    public int getCategoryOfSite(int n) {
        throw new IllegalArgumentException("Integrating across categories");
    }

    @Override
    public double[] getCategoryRates() {
        throw new RuntimeException("getCategoryRates not available in this siteModel");
    }

    @Override
    public double getRateForCategory(int n) {
        throw new RuntimeException("getRateForCategory not available in this siteModel");
    }

    public double getSubstitutionsForCategory(int n, double d) {
        throw new RuntimeException("getSubstitutionsForCategory not available in this siteModel");
    }

    public void getTransitionProbabilities(double d, double[] dArray) {
        throw new RuntimeException("getTransitionProbabilities not available in this siteModel");
    }

    @Override
    public FrequencyModel getFrequencyModel() {
        return ((SubstitutionModel)this.substitutionModels.elementAt(0)).getFrequencyModel();
    }

    @Override
    public double getProportionForCategory(int n) {
        return this.proportionParameter.getParameterValue(n);
    }

    @Override
    public double[] getCategoryProportions() {
        double[] dArray = new double[this.categoryCount];
        for (int i = 0; i < this.categoryCount; ++i) {
            dArray[i] = this.proportionParameter.getParameterValue(i);
        }
        return dArray;
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        this.listenerHelper.fireModelChanged(this, object, n);
    }

    @Override
    protected final void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
    }

    @Override
    protected void storeState() {
    }

    @Override
    protected void restoreState() {
    }

    @Override
    protected void acceptState() {
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    class classSizeBounds
    implements Bounds {
        private final Parameter catProportionUnder;
        private final Parameter catProportionAbove;
        private final Parameter catProportion;

        public classSizeBounds(Parameter parameter, Parameter parameter2, Parameter parameter3) {
            this.catProportionUnder = parameter2;
            this.catProportionAbove = parameter3;
            this.catProportion = parameter;
        }

        public Double getUpperLimit(int n) {
            if (n != 0) {
                throw new RuntimeException("class size parameters have wrong dimension " + n);
            }
            if (this.catProportionUnder == null) {
                return this.catProportion.getParameterValue(n) + this.catProportionAbove.getParameterValue(n);
            }
            return this.catProportion.getParameterValue(n) + this.catProportionUnder.getParameterValue(n);
        }

        public Double getLowerLimit(int n) {
            if (n != 0) {
                throw new RuntimeException("class size parameters have wrong dimension " + n);
            }
            return 0.0;
        }

        @Override
        public int getBoundsDimension() {
            return 1;
        }
    }

    private class omegaBounds
    implements Bounds<Double> {
        private final Parameter lowerOmega;
        private final Parameter upperOmega;

        public omegaBounds(Parameter parameter, Parameter parameter2) {
            this.lowerOmega = parameter;
            this.upperOmega = parameter2;
        }

        public omegaBounds(Parameter parameter, boolean bl) {
            if (bl) {
                this.lowerOmega = parameter;
                this.upperOmega = null;
            } else {
                this.lowerOmega = null;
                this.upperOmega = parameter;
            }
        }

        @Override
        public Double getUpperLimit(int n) {
            if (n != 0) {
                throw new RuntimeException("omega parameters have wrong dimension " + n);
            }
            if (this.upperOmega == null) {
                return 100.0;
            }
            return this.upperOmega.getParameterValue(n);
        }

        @Override
        public Double getLowerLimit(int n) {
            if (n != 0) {
                throw new RuntimeException("omega parameters have wrong dimension " + n);
            }
            if (this.lowerOmega == null) {
                return 0.0;
            }
            return this.lowerOmega.getParameterValue(n);
        }

        @Override
        public int getBoundsDimension() {
            return 1;
        }
    }
}

