/*
 * Decompiled with CFR 0.152.
 */
package dr.util;

import dr.inference.model.Parameter;
import dr.util.Transform;
import dr.xml.AbstractXMLObjectParser;
import dr.xml.AttributeRule;
import dr.xml.ElementRule;
import dr.xml.XMLObject;
import dr.xml.XMLObjectParser;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.ArrayList;

public class TransformParsers {
    public static XMLObjectParser COMPOUND_PARSER = new AbstractXMLObjectParser(){

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            Parameter parameter = (Parameter)xMLObject.getChild(Parameter.class);
            return new Transform.Collection(xMLObject.getAllChildren(Transform.ParsedTransform.class), parameter);
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return new XMLSyntaxRule[]{new ElementRule(Transform.ParsedTransform.class, 1, Integer.MAX_VALUE), new ElementRule(Parameter.class)};
        }

        @Override
        public String getParserDescription() {
            return null;
        }

        @Override
        public Class getReturnType() {
            return Transform.Collection.class;
        }

        @Override
        public String getParserName() {
            return TransformParsers.COMPOUND;
        }
    };
    public static XMLObjectParser COMPOUND_MULTIVARIATE_PARSER = new AbstractXMLObjectParser(){

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            ArrayList<Transform.MultivariableTransform> arrayList = new ArrayList<Transform.MultivariableTransform>();
            for (int i = 0; i < xMLObject.getChildCount(); ++i) {
                arrayList.add(Transform.Util.parseMultivariableTransform(xMLObject.getChild(i)));
            }
            return new Transform.MultivariateArray(arrayList);
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return new XMLSyntaxRule[]{new ElementRule(Transform.ParsedTransform.class, 0, Integer.MAX_VALUE), new ElementRule(Transform.MultivariableTransform.class, 0, Integer.MAX_VALUE)};
        }

        @Override
        public String getParserDescription() {
            return null;
        }

        @Override
        public Class getReturnType() {
            return Transform.MultivariateArray.class;
        }

        @Override
        public String getParserName() {
            return TransformParsers.COMPOUND_MULTIVARIATE;
        }
    };
    public static XMLObjectParser COMPOSE_PARSER = new AbstractXMLObjectParser(){

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            Transform.ParsedTransform parsedTransform;
            XMLObject xMLObject2 = xMLObject.getChild(TransformParsers.OUTER);
            XMLObject xMLObject3 = xMLObject.getChild(TransformParsers.INNER);
            Transform.ParsedTransform parsedTransform2 = (Transform.ParsedTransform)xMLObject2.getChild(Transform.ParsedTransform.class);
            if (!parsedTransform2.equivalent(parsedTransform = (Transform.ParsedTransform)xMLObject3.getChild(Transform.ParsedTransform.class))) {
                throw new XMLParseException("Not equivalent transformations");
            }
            if (parsedTransform2.transform instanceof Transform.UnivariableTransform && parsedTransform.transform instanceof Transform.UnivariableTransform) {
                Transform.ParsedTransform parsedTransform3 = parsedTransform2.clone();
                parsedTransform3.transform = new Transform.Compose((Transform.UnivariableTransform)parsedTransform2.transform, (Transform.UnivariableTransform)parsedTransform.transform);
                return parsedTransform3;
            }
            throw new XMLParseException("Not composable transform types");
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return new XMLSyntaxRule[]{new ElementRule(TransformParsers.OUTER, new XMLSyntaxRule[]{new ElementRule(Transform.ParsedTransform.class)}), new ElementRule(TransformParsers.INNER, new XMLSyntaxRule[]{new ElementRule(Transform.ParsedTransform.class)})};
        }

        @Override
        public String getParserDescription() {
            return null;
        }

        @Override
        public Class getReturnType() {
            return Transform.ParsedTransform.class;
        }

        @Override
        public String getParserName() {
            return TransformParsers.COMPOSE;
        }
    };
    public static XMLObjectParser INVERSE_PARSER = new AbstractXMLObjectParser(){

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            Transform.ParsedTransform parsedTransform = (Transform.ParsedTransform)xMLObject.getChild(Transform.ParsedTransform.class);
            Transform transform = parsedTransform.transform;
            if (transform instanceof Transform.UnivariableTransform) {
                Transform.ParsedTransform parsedTransform2 = parsedTransform.clone();
                parsedTransform2.transform = new Transform.Inverse((Transform.UnivariableTransform)parsedTransform.transform);
                return parsedTransform2;
            }
            throw new XMLParseException("Not invertible transform type");
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return new XMLSyntaxRule[]{new ElementRule(Transform.ParsedTransform.class)};
        }

        @Override
        public String getParserDescription() {
            return null;
        }

        @Override
        public Class getReturnType() {
            return Transform.ParsedTransform.class;
        }

        @Override
        public String getParserName() {
            return TransformParsers.INVERSE;
        }
    };
    public static XMLObjectParser TRANSFORM_PARSER = new AbstractXMLObjectParser(){

        @Override
        public Object parseXMLObject(XMLObject xMLObject) throws XMLParseException {
            String string = (String)xMLObject.getAttribute(TransformParsers.TYPE);
            Transform transform = null;
            for (Transform.Type type : Transform.Type.values()) {
                if (!string.equalsIgnoreCase(type.getName())) continue;
                transform = type.getTransform();
            }
            if (transform == null) {
                throw new XMLParseException("Unrecognized transform type, " + string);
            }
            if (xMLObject.getAttribute(TransformParsers.INVERSE, false).booleanValue()) {
                if (transform instanceof Transform.UnivariableTransform) {
                    transform = new Transform.Inverse((Transform.UnivariableTransform)transform);
                } else {
                    throw new XMLParseException("Non-invertible transform type, " + string);
                }
            }
            Transform.ParsedTransform parsedTransform = new Transform.ParsedTransform();
            if (xMLObject.hasAttribute(TransformParsers.START) && xMLObject.hasAttribute(TransformParsers.DIM)) {
                throw new XMLParseException("Transform can only have one of attributes 'start' or 'dim'.");
            }
            if (xMLObject.hasAttribute(TransformParsers.DIM)) {
                int n = xMLObject.getIntegerAttribute(TransformParsers.DIM);
                parsedTransform.transform = new Transform.Array(transform, n, null);
            } else {
                parsedTransform.transform = transform;
                if (xMLObject.hasAttribute(TransformParsers.START)) {
                    parsedTransform.start = xMLObject.getIntegerAttribute(TransformParsers.START);
                    parsedTransform.end = xMLObject.getAttribute(TransformParsers.END, Integer.MAX_VALUE);
                    parsedTransform.every = xMLObject.getAttribute(TransformParsers.EVERY, 1);
                    --parsedTransform.start;
                } else {
                    if (xMLObject.hasAttribute(TransformParsers.SUM)) {
                        parsedTransform.fixedSum = xMLObject.getDoubleAttribute(TransformParsers.SUM);
                    }
                    parsedTransform.parameters = new ArrayList<Parameter>();
                    parsedTransform.parameters.addAll(xMLObject.getAllChildren(Parameter.class));
                }
            }
            return parsedTransform;
        }

        @Override
        public XMLSyntaxRule[] getSyntaxRules() {
            return new XMLSyntaxRule[]{AttributeRule.newStringRule(TransformParsers.TYPE), AttributeRule.newIntegerRule(TransformParsers.START, true), AttributeRule.newIntegerRule(TransformParsers.END, true), AttributeRule.newIntegerRule(TransformParsers.EVERY, true), AttributeRule.newDoubleRule(TransformParsers.SUM, true), AttributeRule.newBooleanRule(TransformParsers.INVERSE, true), AttributeRule.newIntegerRule(TransformParsers.DIM, true), new ElementRule(Transform.ParsedTransform.class, 0, 1), new ElementRule(Parameter.class, 0, Integer.MAX_VALUE)};
        }

        @Override
        public String getParserDescription() {
            return null;
        }

        @Override
        public Class getReturnType() {
            return Transform.ParsedTransform.class;
        }

        @Override
        public String getParserName() {
            return TransformParsers.TRANSFORM;
        }
    };
    public static final String TRANSFORM = "transform";
    public static final String TYPE = "type";
    public static final String START = "start";
    public static final String END = "end";
    public static final String SUM = "sum";
    public static final String EVERY = "every";
    private static final String INVERSE = "inverseTransform";
    private static final String COMPOSE = "composedTransform";
    private static final String OUTER = "outer";
    private static final String INNER = "inner";
    private static final String COMPOUND = "compoundTransform";
    private static final String DIM = "dim";
    private static final String COMPOUND_MULTIVARIATE = "multivariateCompoundTransform";
}

