/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.tree;

import dr.evolution.tree.NodeRef;
import dr.evolution.tree.Tree;
import dr.evolution.tree.TreeUtils;
import dr.evolution.util.TaxonList;
import dr.evomodel.tree.TreeStatistic;
import dr.inference.model.BooleanStatistic;
import java.util.Set;

public class CladeRelationshipStatistic
extends TreeStatistic
implements BooleanStatistic {
    private Tree tree;
    private final Set<String> leafSetA;
    private final Set<String> leafSetB;
    private final RelationshipType type;

    public CladeRelationshipStatistic(String string, Tree tree, TaxonList taxonList, TaxonList taxonList2, RelationshipType relationshipType) throws TreeUtils.MissingTaxonException {
        super(string);
        this.tree = tree;
        this.leafSetA = TreeUtils.getLeavesForTaxa(tree, taxonList);
        this.leafSetB = TreeUtils.getLeavesForTaxa(tree, taxonList2);
        this.type = relationshipType;
    }

    @Override
    public void setTree(Tree tree) {
        this.tree = tree;
    }

    @Override
    public Tree getTree() {
        return this.tree;
    }

    @Override
    public int getDimension() {
        return 1;
    }

    @Override
    public double getStatisticValue(int n) {
        return this.getBoolean(n) ? 1.0 : 0.0;
    }

    @Override
    public boolean getBoolean(int n) {
        boolean[] blArray = this.getRelationship();
        return this.type.extractResultForType(blArray);
    }

    public boolean[] getRelationship() {
        boolean[] blArray = new boolean[2];
        NodeRef nodeRef = TreeUtils.getCommonAncestorNode(this.tree, this.leafSetA);
        NodeRef nodeRef2 = TreeUtils.getCommonAncestorNode(this.tree, this.leafSetB);
        NodeRef nodeRef3 = TreeUtils.getCommonAncestorNode(this.tree, nodeRef, nodeRef2);
        if (this.tree.getParent(nodeRef) == this.tree.getParent(nodeRef2)) {
            blArray[0] = true;
        } else if (nodeRef3 == nodeRef2) {
            blArray[1] = true;
        }
        return blArray;
    }

    public static RelationshipType factory(String string) {
        for (RelationshipType relationshipType : RelationshipType.values()) {
            if (!string.equalsIgnoreCase(relationshipType.name)) continue;
            return relationshipType;
        }
        return null;
    }

    public static enum RelationshipType {
        SISTER("sister"){

            @Override
            public boolean extractResultForType(boolean[] blArray) {
                return blArray[0];
            }
        }
        ,
        A_IN_B("aInB"){

            @Override
            public boolean extractResultForType(boolean[] blArray) {
                return blArray[1];
            }
        };

        private String name;

        private RelationshipType(String string2) {
            this.name = string2;
        }

        public String getName() {
            return this.name;
        }

        public abstract boolean extractResultForType(boolean[] var1);
    }
}

