/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.distribution;

import dr.inference.distribution.shrinkage.BayesianBridgeStatisticsProvider;
import dr.inference.model.AbstractModelLikelihood;
import dr.inference.model.Model;
import dr.inference.model.Parameter;
import dr.inference.model.Variable;
import dr.math.distributions.RandomFieldDistribution;

public class RandomField
extends AbstractModelLikelihood {
    protected final Parameter field;
    private final RandomFieldDistribution distribution;
    private boolean likelihoodKnown;
    private double logLikelihood;
    private boolean savedLikelihoodKnown;
    private double savedLogLikelihood;

    public RandomField(String string, Parameter parameter, RandomFieldDistribution randomFieldDistribution) {
        super(string);
        this.field = parameter;
        this.distribution = randomFieldDistribution;
        this.addVariable(parameter);
        this.addModel(randomFieldDistribution);
        this.likelihoodKnown = false;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + " " + this.getModelName() + " (" + this.getLogLikelihood() + ")";
    }

    public Parameter getField() {
        return this.field;
    }

    public RandomFieldDistribution getDistribution() {
        return this.distribution;
    }

    @Override
    protected void handleModelChangedEvent(Model model, Object object, int n) {
        if (model != this.distribution) {
            throw new IllegalArgumentException("Unknown model");
        }
        this.likelihoodKnown = false;
    }

    @Override
    protected void handleVariableChangedEvent(Variable variable, int n, Variable.ChangeType changeType) {
        if (variable != this.field) {
            throw new IllegalArgumentException("Unknown variable");
        }
        this.likelihoodKnown = false;
    }

    @Override
    protected void storeState() {
        this.savedLikelihoodKnown = this.likelihoodKnown;
        this.savedLogLikelihood = this.logLikelihood;
    }

    @Override
    protected void restoreState() {
        this.likelihoodKnown = this.savedLikelihoodKnown;
        this.logLikelihood = this.savedLogLikelihood;
    }

    @Override
    protected void acceptState() {
    }

    @Override
    public Model getModel() {
        return this;
    }

    @Override
    public double getLogLikelihood() {
        if (!this.likelihoodKnown) {
            this.logLikelihood = this.distribution.logPdf(this.field.getParameterValues());
            this.likelihoodKnown = true;
        }
        return this.logLikelihood;
    }

    @Override
    public void makeDirty() {
        this.likelihoodKnown = false;
    }

    public static class BayesianBridge
    extends RandomField
    implements BayesianBridgeStatisticsProvider {
        private final BayesianBridgeStatisticsProvider bayesianBridge;

        public BayesianBridge(String string, Parameter parameter, RandomFieldDistribution randomFieldDistribution) {
            super(string, parameter, randomFieldDistribution);
            if (!(randomFieldDistribution instanceof BayesianBridgeStatisticsProvider)) {
                throw new IllegalArgumentException("Must provider a BayesianBridgeStatisticsProvider");
            }
            this.bayesianBridge = (BayesianBridgeStatisticsProvider)((Object)randomFieldDistribution);
        }

        @Override
        public double getCoefficient(int n) {
            return this.getDistribution().getIncrement(n, this.field);
        }

        @Override
        public Parameter getGlobalScale() {
            return this.bayesianBridge.getGlobalScale();
        }

        @Override
        public Parameter getLocalScale() {
            return this.bayesianBridge.getLocalScale();
        }

        @Override
        public Parameter getExponent() {
            return this.bayesianBridge.getExponent();
        }

        @Override
        public Parameter getSlabWidth() {
            return this.bayesianBridge.getSlabWidth();
        }

        @Override
        public int getDimension() {
            return this.bayesianBridge.getDimension();
        }
    }

    public static interface WeightProvider
    extends Model {
        public double weight(int var1, int var2);

        public int getDimension();
    }
}

