/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.distribution;

import dr.inference.distribution.RandomField;
import dr.inference.hmc.GradientWrtParameterProvider;
import dr.inference.model.GradientProvider;
import dr.inference.model.Likelihood;
import dr.inference.model.Parameter;
import dr.math.distributions.RandomFieldDistribution;
import dr.xml.Reportable;

public class RandomFieldGradient
implements GradientWrtParameterProvider,
Reportable {
    private final RandomField randomField;
    private final Parameter parameter;
    private final RandomFieldDistribution distribution;
    private final GradientProvider provider;

    public RandomFieldGradient(RandomField randomField, final Parameter parameter) {
        this.randomField = randomField;
        this.parameter = parameter;
        this.distribution = randomField.getDistribution();
        this.provider = parameter == randomField.getField() ? new GradientProvider(){

            @Override
            public int getDimension() {
                return parameter.getDimension();
            }

            @Override
            public double[] getGradientLogDensity(Object object) {
                return RandomFieldGradient.this.distribution.getGradientLogDensity(object);
            }
        } : this.distribution.getGradientWrt(parameter);
    }

    @Override
    public String getReport() {
        return GradientWrtParameterProvider.getReportAndCheckForError(this, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, null);
    }

    @Override
    public Likelihood getLikelihood() {
        return this.randomField;
    }

    @Override
    public Parameter getParameter() {
        return this.parameter;
    }

    @Override
    public int getDimension() {
        return this.parameter.getDimension();
    }

    @Override
    public double[] getGradientLogDensity() {
        return this.provider.getGradientLogDensity(this.randomField.getField().getParameterValues());
    }
}

