/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import java.util.Iterator;
import no.uib.cipr.matrix.AbstractBandMatrix;
import no.uib.cipr.matrix.BLASkernel;
import no.uib.cipr.matrix.BandMatrix;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Interface;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixEntry;
import no.uib.cipr.matrix.MatrixNotSPDException;
import no.uib.cipr.matrix.MatrixSingularException;
import no.uib.cipr.matrix.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractSymmBandMatrix
extends AbstractBandMatrix {
    private BLASkernel.UpLo uplo;
    int kd;

    AbstractSymmBandMatrix(int n, int kl, int ku, BLASkernel.UpLo uplo) {
        super(n, kl, ku);
        this.kd = Math.max(kl, ku);
        this.uplo = uplo;
    }

    AbstractSymmBandMatrix(Matrix A, int kl, int ku, BLASkernel.UpLo uplo) {
        this(A, kl, ku, true, uplo);
    }

    AbstractSymmBandMatrix(Matrix A, int kl, int ku, boolean deep, BLASkernel.UpLo uplo) {
        super(A, kl, ku, deep);
        this.kd = Math.max(kl, ku);
        this.uplo = uplo;
    }

    @Override
    public Vector multAdd(double alpha, Vector x, Vector y) {
        if (!(x instanceof DenseVector) || !(y instanceof DenseVector)) {
            return super.multAdd(alpha, x, y);
        }
        this.checkMultAdd(x, y);
        double[] xd = ((DenseVector)x).getData();
        double[] yd = ((DenseVector)y).getData();
        Interface.blas().sbmv(this.uplo, this.numRows, this.kd, alpha, this.data, this.kd + 1, xd, 1.0, yd);
        return y;
    }

    @Override
    public Vector transMultAdd(double alpha, Vector x, Vector y) {
        return this.multAdd(alpha, x, y);
    }

    @Override
    public Iterator<MatrixEntry> iterator() {
        return new AbstractBandMatrix.BandMatrixIterator(this.kd, this.kd);
    }

    @Override
    public Matrix solve(Matrix B, Matrix X) {
        if (!(X instanceof DenseMatrix)) {
            throw new UnsupportedOperationException("X must be a DenseMatrix");
        }
        this.checkSolve(B, X);
        double[] Xd = ((DenseMatrix)X).getData();
        X.set(B);
        BandMatrix Af = new BandMatrix(this, this.kd, this.kd + this.kd);
        int[] ipiv = new int[this.numRows];
        int info = Interface.lapack().gbsv(this.numRows, this.kd, this.kd, X.numColumns(), Af.getData(), ipiv, Xd);
        if (info > 0) {
            throw new MatrixSingularException();
        }
        if (info < 0) {
            throw new IllegalArgumentException();
        }
        return X;
    }

    @Override
    public Vector solve(Vector b, Vector x) {
        DenseMatrix B = new DenseMatrix(b, false);
        DenseMatrix X = new DenseMatrix(x, false);
        this.solve(B, X);
        return x;
    }

    @Override
    public Matrix transSolve(Matrix B, Matrix X) {
        return this.solve(B, X);
    }

    @Override
    public Vector transSolve(Vector b, Vector x) {
        return this.solve(b, x);
    }

    Matrix SPDsolve(Matrix B, Matrix X) {
        if (!(X instanceof DenseMatrix)) {
            throw new UnsupportedOperationException("X must be a DenseMatrix");
        }
        this.checkSolve(B, X);
        double[] Xd = ((DenseMatrix)X).getData();
        X.set(B);
        int info = Interface.lapack().pbsv(this.uplo, this.numRows, this.kd, X.numColumns(), (double[])this.data.clone(), Xd);
        if (info > 0) {
            throw new MatrixNotSPDException();
        }
        if (info < 0) {
            throw new IllegalArgumentException();
        }
        return X;
    }

    @Override
    public Matrix transpose() {
        return this;
    }
}

