% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BoneDensityFunctions.R
\name{import_scan}
\alias{import_scan}
\title{import CT scan}
\usage{
import_scan(scan_filepath)
}
\arguments{
\item{scan_filepath}{String. File path to CT scan data. Should be .nii or .nrrd}
}
\value{
scan object
}
\description{
import CT scan
}
\examples{
\donttest{
  # Download CT scan
  url <- "https://github.com/Telfer/BoneDensityMapping/releases/download/v1.0.2/test_CT_hip.nii.gz"
  scan_filepath <- tempfile(fileext = ".nii.gz")
  download.file(url, scan_filepath, mode = "wb")
  import_scan(scan_filepath)
}
}
\author{
Scott Telfer \email{scott.telfer@gmail.com}
}
