% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/descide_master_functions.R
\name{descide}
\alias{descide}
\title{Run DeSciDe pipeline}
\usage{
descide(
  genes_list,
  terms_list,
  rank_method = "weighted",
  species = 9606,
  network_type = "full",
  score_threshold = 400,
  threshold_percentage = 20,
  export = FALSE,
  file_directory = NULL,
  export_format = "csv"
)
}
\arguments{
\item{genes_list}{A list of gene IDs.}

\item{terms_list}{A list of search terms.}

\item{rank_method}{The method to rank pubmed results, either "weighted" or "total". Weighted ranks results based on order of terms inputted. Total ranks results on total sum of publications across all search term combinations. Defaults to "weighted".}

\item{species}{The NCBI taxon ID of the species. Defaults to 9606 (Homo sapiens).}

\item{network_type}{The type of string network to use, either "full" or "physical". Defaults to "full".}

\item{score_threshold}{The minimum score threshold for string interactions. Defaults to 400.}

\item{threshold_percentage}{Percentage threshold for ranking (default is 20\%).}

\item{export}{Logical indicating whether to export the results. Defaults to FALSE.}

\item{file_directory}{Directory for saving the output files. Defaults to NULL.}

\item{export_format}{Format for export, either "csv", "tsv", or "excel".}
}
\value{
A list containing the PubMed search results, STRING results, and summary results.
}
\description{
Run the entire analysis pipeline including PubMed search, STRING database search, and plotting.
}
\examples{
\donttest{
genes <- c("TP53", "BRCA1")
terms <- c("cancer", "tumor")
results <- descide(genes, terms, export = FALSE)
str(results)
}
}
