% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wordcloud.R
\name{wordcloud}
\alias{wordcloud}
\title{Generate a word cloud for excerpts by code}
\usage{
wordcloud(data, code, max_words = 100, custom_stopwords = NULL)
}
\arguments{
\item{data}{A data.frame or tibble containing at least one \code{excerpt} column
and one or more code columns starting with \code{"c_"}.}

\item{code}{A string giving the name of the code column to filter on (e.g. "c_belonging").}

\item{max_words}{Maximum number of words to display in the word cloud (default = 100).}

\item{custom_stopwords}{A character vector of additional stop words to remove
(default = \code{NULL}).}
}
\value{
An interactive word cloud (from \pkg{wordcloud2}).
}
\description{
Creates a word cloud of words from all excerpts where a given code is applied.
Common English stop words, user-supplied stop words, and punctuation are removed.
}
\examples{
library(dplyr)
df <- tibble::tibble(
  excerpt = c(
    "I felt connected to peers and friends.",
    "We should normalize conversations about mental health.",
    "My teachers helped me belong at school.",
    "I am comfortable talking about suicide prevention."
  ),
  c_belonging = c(TRUE, FALSE, TRUE, FALSE),
  c_destigmatization = c(FALSE, TRUE, FALSE, FALSE)
)

# Word cloud for belonging excerpts
wordcloud(df, "c_belonging")

# With custom stop words
wordcloud(df, "c_belonging", custom_stopwords = c("connected", "school"))

}
