% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnosis.R
\name{dt_dia}
\alias{dt_dia}
\title{Train a Decision Tree Model for Classification}
\usage{
dt_dia(X, y, tune = FALSE, cv_folds = 5)
}
\arguments{
\item{X}{A data frame of features.}

\item{y}{A factor vector of class labels.}

\item{tune}{Logical, whether to perform hyperparameter tuning for \code{cp}
(complexity parameter) (if \code{TRUE}) or use a fixed value (if \code{FALSE}).}

\item{cv_folds}{An integer, the number of cross-validation folds for \code{caret}.}
}
\value{
A \code{caret::train} object representing the trained Decision Tree model.
}
\description{
Trains a single Decision Tree model using \code{caret::train} (via \code{rpart} method)
for binary classification.
}
\examples{
\donttest{
set.seed(42)
n_obs <- 50
X_toy <- data.frame(
  FeatureA = rnorm(n_obs),
  FeatureB = runif(n_obs, 0, 100)
)
y_toy <- factor(sample(c("Control", "Case"), n_obs, replace = TRUE),
                levels = c("Control", "Case"))

# Train the model
dt_model <- dt_dia(X_toy, y_toy)
print(dt_model)
}
}
