% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indqi.R
\name{is_qindustrial}
\alias{is_qindustrial}
\title{Industrial quality of wheat}
\usage{
is_qindustrial(GEN, NQ, W, PTN, verbose = TRUE)
}
\arguments{
\item{GEN}{The column with the genotype name}

\item{NQ}{The column with the falling number}

\item{W}{The column with the gluten force (W)}

\item{PTN}{The column with the protein values}

\item{verbose}{Logical argument. Runs the code silently if FALSE.}
}
\value{
Determines the industrial quality index for wheat crops, when
considering variables used to classify wheat cultivars.
}
\description{
Function for determining industrial quality indices of wheat genotypes,
described by Szareski et al. (2019).
}
\examples{
library(EstimateBreed)

data("ptn")
with(ptn,is_qindustrial(Cult,NQ,W,PTN))
}
\references{
Szareski, V. J., Carvalho, I. R., Kehl, K., Levien, A. M.,
Lautenchleger, F., Barbosa, M. H., ... & Aumonde, T. Z. (2019).
Genetic and phenotypic multi-character approach applied to multivariate
models for wheat industrial quality analysis.
Genetics and Molecular Research, 18(3), 1-14.
}
\author{
Willyan Junior Adorian Bandeira

Ivan Ricardo Carvalho

Murilo Vieira Loro

Leonardo Cesar Pradebon

Jose Antonio Gonzalez da Silva
}
