% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.HazardShape.R
\encoding{UTF-8}
\name{plot.HazardShape}
\alias{plot.HazardShape}
\title{Plot of \code{HazardShape} objects}
\usage{
\method{plot}{HazardShape}(
  x,
  xlab = "i/n",
  ylab = expression(phi[n](i/n)),
  xlim = c(0, 1),
  ylim = c(0, 1),
  col = 1,
  lty = NULL,
  lwd = NA,
  main = "",
  curve_options = list(col = 2, lwd = 2, lty = 1),
  par_plot = lifecycle::deprecated(),
  legend_options = lifecycle::deprecated(),
  ...
)
}
\arguments{
\item{x}{an object of class \code{initValOW}, generated with
\code{\link{TTT_hazard_shape}}.}

\item{xlab, ylab}{titles for x and y axes, as in \code{\link{plot}}.}

\item{xlim}{the x limits (x1, x2) of the plot.}

\item{ylim}{the y limits (x1, x2) of the plot.}

\item{col}{the colors for lines and points. Multiple colors can be specified.
This is the usual color argument of
\code{\link[graphics]{plot.default}}.}

\item{lty}{a vector of line types, see \code{\link{par}} for further
information.}

\item{lwd}{a vector of line widths, see \code{\link{par}} for further
information.}

\item{main}{a main title for the plot.}

\item{curve_options}{a list with further arguments useful for customization
of non-parametric estimate plot.}

\item{par_plot}{(deprecated) some graphical parameters which can be passed to the plot.
See \strong{Details} section for further information.}

\item{legend_options}{(deprecated) a list with fur further arguments useful for
customization. See \strong{Details} section for further information.
of the legend of the plot.}

\item{...}{further arguments passed to empirical TTT plot.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#maturing}{\figure{lifecycle-maturing.svg}{options: alt='[Maturing]'}}}{\strong{[Maturing]}}

Draws the empirical total time on test (TTT) plot and its non-parametric
(LOESS) estimated curve useful for identifying hazard shape.
}
\details{
This plot complements the use of \code{\link{TTT_hazard_shape}}. It is always
advisable to use this function in order to check the result of non-parametric
estimate of TTT plot. See the first example in \strong{Examples} section for
an illustration.
}
\examples{
library(EstimationTools)

#----------------------------------------------------------------------------
# Example 1: Increasing hazard and its corresponding TTT plot with simulated
# data
hweibull <- function(x, shape, scale) {
  dweibull(x, shape, scale) / pweibull(x, shape, scale, lower.tail = FALSE)
}
curve(hweibull(x, shape = 2.5, scale = pi),
  from = 0, to = 42,
  col = "red", ylab = "Hazard function", las = 1, lwd = 2
)

y <- rweibull(n = 50, shape = 2.5, scale = pi)
my_initial_guess <- TTT_hazard_shape(formula = y ~ 1)

par(mar = c(3.7, 3.7, 1, 2), mgp = c(2.5, 1, 0))
plot(my_initial_guess)

#----------------------------------------------------------------------------

}
\author{
Jaime Mosquera Gutiérrez \email{jmosquerag@unal.edu.co}
}
