% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Fuzzifier_16102018_bis.R
\name{FUZZ}
\alias{FUZZ}
\title{Fuzzifies a variable modelled by trapezoidal or triangular fuzzy numbers}
\usage{
FUZZ(data, mi, si, PA)
}
\arguments{
\item{data}{a data set.}

\item{mi}{the index of the main-item containing the concerned variable.}

\item{si}{the index of the sub-item of a given main-item mi.}

\item{PA}{a vector of the linguistic terms of the considered variable.}
}
\value{
A fuzzification matrix composed by 4 columns c(p,q,r,s), and m lines, i.e. number of observations. No NA is allowed.
}
\description{
Fuzzifies a variable modelled by trapezoidal or triangular fuzzy numbers
}
\examples{
data <- matrix(c(1,2,3,2,2,1,1,3,1,2),ncol=1)
MF111 <- TrapezoidalFuzzyNumber(0,1,1,2)
MF112 <- TrapezoidalFuzzyNumber(1,2,2,3)
MF113 <- TrapezoidalFuzzyNumber(2,3,3,3)
PA11 <- c(1,2,3)
data.fuzzified <- FUZZ(data,mi=1,si=1,PA=PA11)
is.trfuzzification(data.fuzzified)
}
