% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getDescriptionStatsBy_prPropDescs.R
\name{prPropDescs}
\alias{prPropDescs}
\title{Helper to [getDescriptionStatsBy()]}
\usage{
prPropDescs(
  x,
  by,
  name,
  default_ref,
  prop_fn,
  html,
  digits,
  digits.nonzero,
  numbers_first,
  useNA,
  useNA.digits,
  percentage_sign,
  missing_value,
  names_of_missing,
  NEJMstyle
)
}
\arguments{
\item{x}{If a data.frame it will be used as the data source for the variables in the \code{...} parameter.
If it is a single variable it will be the core value that want the statistics for.
In the print this is equivalent to the output of this function.}

\item{by}{The variable that you want to split into different columns}

\item{name}{The name of the row}

\item{default_ref}{The default reference when dealing with proportions. When using
`dplyr` syntax (`tidyselect`) you can specify a named vector/list for each column name.}

\item{prop_fn}{The method used to describe proportions, see \code{\link{describeProp}}.}

\item{html}{If HTML compatible output should be used. If \code{FALSE}
it outputs LaTeX formatting}

\item{digits}{The number of decimals used}

\item{digits.nonzero}{The number of decimals used for values that are close to zero}

\item{numbers_first}{If the number should be given or if the percentage
should be presented first. The second is encapsulated in parentheses ().}

\item{useNA}{This indicates if missing should be added as a separate
row below all other. See \code{\link[base]{table}} for \code{useNA}-options.
\emph{Note:} defaults to ifany and not "no" as \code{\link[base]{table}} does.}

\item{useNA.digits}{The number of digits to use for the
missing percentage, defaults to the overall \code{digits}.}

\item{percentage_sign}{If you want to suppress the percentage sign you
can set this variable to FALSE. You can also choose something else that
the default \% if you so wish by setting this variable.}

\item{missing_value}{Value that is substituted for empty cells. Defaults to "-"}

\item{names_of_missing}{Optional character vector containing the names of returned statistics,
in case all returned values for a given \code{by} level are missing. Defaults to NULL}

\item{NEJMstyle}{Adds - no (\%) at the end to proportions}
}
\value{
A [base::by] list
}
\description{
Helper to [getDescriptionStatsBy()]
}
