% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/afs.R
\name{afs}
\alias{afs}
\title{Analogy from stimuli.}
\usage{
afs(
  path,
  type = "F",
  sa,
  sb,
  sc,
  s1 = "No content",
  s2 = "No content",
  s3 = "No content",
  s4 = "No content",
  s5 = "No content",
  s6 = "No content",
  s7 = "No content",
  s8 = "No content",
  s9 = "No content",
  s10 = "No content",
  relations = "A",
  question = T,
  labels = "L",
  ai.idn = F,
  size.arrow = 34,
  size.arrowhead = 3,
  size.colon = 55,
  size.relword = 32,
  size.q = 85,
  size.word = 32,
  size.label = 25,
  language = "E",
  out = "item"
)
}
\arguments{
\item{path}{Directory where files are saved and/or collected. For example: \code{"C:/Desktop/Folder"}. For a figural item, figural stimuli should be placed inside the correspondent folder.}

\item{type}{Should the \code{afs} function create a figural (\code{"F"}) or a verbal (\code{"V"}) item?}

\item{sa}{String with stimulus name A of an A:B::C:D analogy, including ".png" extension when \code{type = "F"}.}

\item{sb}{String with stimulus name B of an A:B::C:D analogy, including ".png" extension when \code{type = "F"}.}

\item{sc}{String with stimulus name C of an A:B::C:D analogy, including ".png" extension when \code{type = "F"}.}

\item{s1}{String with response option name 1, including ".png" extension when \code{type = "F"}.}

\item{s2}{String with response option name 2, including ".png" extension when \code{type = "F"}.}

\item{s3}{String with response option name 3, including ".png" extension when \code{type = "F"}.}

\item{s4}{String with response option name 4, including ".png" extension when \code{type = "F"}.}

\item{s5}{String with response option name 5, including ".png" extension when \code{type = "F"}.}

\item{s6}{String with response option name 6, including ".png" extension when \code{type = "F"}.}

\item{s7}{String with response option name 7, including ".png" extension when \code{type = "F"}.}

\item{s8}{String with response option name 8, including ".png" extension when \code{type = "F"}.}

\item{s9}{String with response option name 9, including ".png" extension when \code{type = "F"}.}

\item{s10}{String with response option name 10, including ".png" extension when \code{type = "F"}.}

\item{relations}{Should analogical relations be indicated by arrows and a colon (\code{"A"}), just colons (\code{"C"}) or words (\code{"W"})?}

\item{question}{Should there be a question mark?}

\item{labels}{Should options be labeled by letters (\code{"L"}), numbers (\code{"N"}) or no labels (\code{F})?}

\item{ai.idn}{Should there be "All incorrect" and "I don't know" options?}

\item{size.arrow}{Thickness of the arrow.}

\item{size.arrowhead}{Size of the arrowhead.}

\item{size.colon}{Size of the colon.}

\item{size.relword}{Size of words that relate the stimuli of the A:B::C:D stem to each other.}

\item{size.q}{Size of the question mark.}

\item{size.word}{Size of verbal stimuli excluding labels and words of the stem (for these two, use \code{size.label} and \code{size.relword} respectively).}

\item{size.label}{Size of labels.}

\item{language}{Language of verbal stimuli including words of the stem.}

\item{out}{Output file name.}
}
\value{
A PNG file containing the item.
}
\description{
Creates an analogy item from pre-made stimuli, the latter being either figural or verbal.
To create figural analogies from stimuli generated by IMak, the
\code{\link{build_fa}} and \code{\link{plot_fa}} functions should be used.
}
\details{
Create an analogy item by using pre-made stimuli. Such stimuli can be either figural or
verbal, and it should be sufficient to complete the A, B and C terms of an A:B::C:D analogy stem
plus at least two answer options. Use a source/target folder to save the item by providing an
argument to \code{path}. For a figural item, save the pre-made figures as PNG files inside that folder
(the ideal would be to supply perfect-square high-resolution images).
Give arguments to \code{sa}, \code{sb} and \code{sc}, thus indicating the names of stimuli A, B and C.
Give arguments to \code{s1} and \code{s2} to indicate the names of two answer options. Provide further arguments
to parameters \code{s3} to \code{s10} if you would like to add up to 10 options in total. All of these
names are the image file names plus their ".png" extensions when you want to create a figural item.
Include "All incorrect" and "I don't know" options by setting \code{ai.idn} to \code{TRUE}. Other variables
that can be altered are: the way of indicating the A:B::C:D relations, the question mark,
the option labels, the sizes and the language of verbal stimuli.
}
\author{
Diego Blum \email{blumworx@gmail.com}
}
