/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.matrix.tfloat.algo.solver;

import cern.colt.matrix.tfloat.FloatMatrix1D;
import cern.colt.matrix.tfloat.FloatMatrix2D;
import cern.colt.matrix.tfloat.algo.solver.AbstractFloatIterativeSolver;
import cern.colt.matrix.tfloat.algo.solver.IterativeSolverFloatNotConvergedException;
import cern.jet.math.tfloat.FloatFunctions;

public class FloatIR
extends AbstractFloatIterativeSolver {
    private FloatMatrix1D z;
    private FloatMatrix1D r;

    public FloatIR(FloatMatrix1D floatMatrix1D) {
        this.z = floatMatrix1D.copy();
        this.r = floatMatrix1D.copy();
    }

    public FloatMatrix1D solve(FloatMatrix2D floatMatrix2D, FloatMatrix1D floatMatrix1D, FloatMatrix1D floatMatrix1D2) throws IterativeSolverFloatNotConvergedException {
        this.checkSizes(floatMatrix2D, floatMatrix1D, floatMatrix1D2);
        floatMatrix2D.zMult(floatMatrix1D2, this.r.assign(floatMatrix1D), -1.0f, 1.0f, false);
        this.iter.setFirst();
        while (!this.iter.converged(this.r, floatMatrix1D2)) {
            this.M.apply(this.r, this.z);
            floatMatrix1D2.assign(this.z, FloatFunctions.plus);
            floatMatrix2D.zMult(floatMatrix1D2, this.r.assign(floatMatrix1D), -1.0f, 1.0f, false);
            this.iter.next();
        }
        return floatMatrix1D2;
    }
}

