% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/age.R
\name{age2ratio}
\alias{age2ratio}
\title{Predict isotopic ratios from ages}
\usage{
age2ratio(
  tt,
  st = 0,
  ratio = "Pb206U238",
  exterr = FALSE,
  d = diseq(),
  J,
  sJ = 0,
  bratio = 0.895
)
}
\arguments{
\item{tt}{a scalar or (except when \code{ratio} =
\code{'Wetherill'}, \code{'Tera-Wasserburg'} or
\code{'U-Th-Pb'}) vector of ages.}

\item{st}{a scalar or (except when \code{ratio} =
\code{'Wetherill'}, \code{'Tera-Wasserburg'} or
\code{'U-Th-Pb'}) vector with the standard error(s) of
\code{tt}. Not used when \code{ratio} =
\code{'Stacey-Kramers'}.}

\item{ratio}{one of \code{'Pb206U238'}, \code{'Pb207U235'},
\code{'U238Pb206'}, \code{'Pb207Pb206'}, \code{'Pb208Th232'},
\code{'Wetherill'}, \code{'Tera-Wasserburg'}, \code{'U-Th-Pb'},
\code{'Ar40Ar39'}, \code{'Ca40K40'}, \code{'Hf176Lu176'},
\code{'Sr87Rb87'}, \code{'Os187Re187'}, \code{'Nd143Sm147'} or
\code{'Stacey-Kramers'}.}

\item{exterr}{logical. If \code{TRUE}, propagates decay constant
uncertainties into \code{st}. Not used when \code{ratio} =
\code{'Stacey-Kramers'}.}

\item{d}{an object of class \link{diseq}.}

\item{J}{the J-factor of the Ar--Ar system (only used if
\code{ratio} is \code{'Ar40Ar39'}).}

\item{sJ}{the standard error of \code{J} (only used if \code{ratio}
is \code{'Ar40Ar39'}).}

\item{bratio}{branching ratio of \eqn{^40}K}
}
\value{
If \code{ratio} is \code{'Pb207U235'}, \code{'U238Pb206'},
    \code{'Pb207Pb206'}, \code{'Pb208Th232'}, \code{'Ar40Ar39'},
    \code{'Ca40K40'}, \code{'Hf176Lu176'}, \code{'Sr87Rb87'},
    \code{'Os187Re187'} or \code{'Nd143Sm147'}: either a
    two-element vector or a two-column matrix with the predicted
    isotopic ratio(s) and its/their standard error(s).

If \code{ratio} is \code{'Wetherill'}, \code{'Tera-Wasserburg'} or
    \code{'U-Th-Pb'}: a two-element list containing

\code{x}: the concordia ratios

\code{cov}: the covariance matrix of the concordia ratios

If \code{ratio} is \code{'Stacey-Kramers'}: a three-column matrix
with predicted \eqn{^{206}}Pb/\eqn{^{204}}Pb,
\eqn{^{207}}Pb/\eqn{^{204}}Pb and \eqn{^{208}}Pb/\eqn{^{204}}Pb
ratios.
}
\description{
Groups a set of functions that take one (or more) ages
    (and their uncertainties) as input and produces the U--Pb,
    Th--Pb, Pb--Pb, Ar--Ar, K--Ca, Rb--Sr, Sm--Nd, Lu--Hf, Re--Os,
    concordia or Stacey-Kramers ratios as output.
}
\examples{
ratios <- c('Pb206U238','Pb207U235','U238Pb206','Pb207Pb206',
            'Pb208Th232','Wetherill','Tera-Wasserburg','U-Th-Pb',
            'Ar40Ar39','Ca40K40','Hf176Lu176','Sr87Rb87',
            'Os187Re187','Nd143Sm147','Stacey-Kramers')
for (ratio in ratios){
     r <- age2ratio(tt=1000,st=10,ratio=ratio,J=1,sJ=0.1)
     print(r)
}
}
